/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Config;
import b100.installer.Versions;
import b100.installer.gui.classic.BaseInstallerGUI;
import b100.installer.gui.classic.GuiUtils;
import b100.installer.gui.classic.InstallerGuiClassic;
import b100.installer.gui.classic.VersionComponent;
import b100.installer.installer.BetacraftInstaller;
import b100.installer.installer.ProgressListener;
import b100.installer.util.ModLoader;
import b100.installer.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JTextField;

public class BetacraftInstallerGUI
extends BaseInstallerGUI {
    public static final String INSTALL_TYPE = "betacraft";
    public JTextField betacraftDirectoryTextfield;
    public JTextField instanceTextfield;
    public BetacraftInstaller betacraftInstaller = new BetacraftInstaller();

    public BetacraftInstallerGUI(InstallerGuiClassic installerGUI) {
        super(installerGUI);
        int inset = 4;
        this.getGridBagConstraints().insets.set(inset, inset, inset, inset);
        this.betacraftDirectoryTextfield = new JTextField();
        this.betacraftDirectoryTextfield.setText(this.getBetaCraftDirectory());
        this.instanceTextfield = new JTextField();
        this.instanceTextfield.setText("Better than Adventure!");
        ArrayList<ModLoader> modLoaders = new ArrayList<ModLoader>();
        modLoaders.add(ModLoader.None);
        this.versionComponent = new VersionComponent(modLoaders, (version, modLoader) -> modLoader == ModLoader.None && this.isVersionSupported(version));
        this.installButton = new JButton("Install");
        this.installButton.addActionListener(this);
        this.add(GuiUtils.createImagePanel("/logo.png"), 0, 0, 1.0, 1.0);
        this.add(GuiUtils.createTitledPanel(this.betacraftDirectoryTextfield, "BetaCraft Directory"), 0, 1, 1.0, 0.0);
        this.add(GuiUtils.createTitledPanel(this.instanceTextfield, "Instance"), 0, 2, 1.0, 0.0);
        this.add(this.versionComponent, 0, 3, 1.0, 0.0);
        this.add(this.installButton, 0, 4, 1.0, 0.0);
    }

    public boolean isVersionSupported(String versionId) {
        Versions.Version version = Versions.getInstance().get(versionId);
        return version.manifest.getObject(INSTALL_TYPE) != null;
    }

    @Override
    public boolean install() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("version", this.versionComponent.getSelectedVersion().id);
        parameters.put("loader", (Object)this.versionComponent.getSelectedLoader());
        parameters.put("betacraftdir", this.betacraftDirectoryTextfield.getText());
        parameters.put("instancename", this.instanceTextfield.getText());
        return this.betacraftInstaller.install(parameters, new ProgressListener.Dummy());
    }

    public String getBetaCraftDirectory() {
        String last = Config.getInstance().lastBetaCraftDirectory.value;
        if (last != null) {
            return last;
        }
        return BetacraftInstallerGUI.getDefaultBetacraftDirectory().getAbsolutePath();
    }

    public static File getDefaultBetacraftDirectory() {
        boolean isMac;
        String folder = null;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.indexOf("win") >= 0;
        boolean isLinux = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0;
        boolean bl = isMac = os.indexOf("mac") >= 0;
        if (isWindows) {
            folder = String.valueOf(System.getenv("APPDATA")) + "\\.betacraft\\";
        } else if (isLinux) {
            folder = String.valueOf(System.getProperty("user.home")) + "/.betacraft";
        } else if (isMac) {
            folder = String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/betacraft/";
        } else {
            return Utils.getAppDirectory(INSTALL_TYPE);
        }
        return new File(folder);
    }
}

