/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.classic;

import b100.installer.Config;
import b100.installer.gui.classic.BaseInstallerGUI;
import b100.installer.gui.classic.GuiUtils;
import b100.installer.gui.classic.InstallerGuiClassic;
import b100.installer.gui.classic.VersionComponent;
import b100.installer.installer.MultiMCInstaller;
import b100.installer.installer.ProgressListener;
import b100.installer.util.ModLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JTextField;

public class MultiMCInstallerGUI
extends BaseInstallerGUI {
    public static final String INSTALL_TYPE = "multimc";
    public JTextField multimcDirectoryTextfield;
    public MultiMCInstaller multiMCInstaller = new MultiMCInstaller();

    public MultiMCInstallerGUI(InstallerGuiClassic installerGUI) {
        super(installerGUI);
        int inset = 4;
        this.getGridBagConstraints().insets.set(inset, inset, inset, inset);
        this.multimcDirectoryTextfield = new JTextField(Config.getInstance().lastMultimcDirectory.value);
        ArrayList<ModLoader> modLoaders = new ArrayList<ModLoader>();
        modLoaders.add(ModLoader.None);
        this.versionComponent = new VersionComponent(modLoaders, this.multiMCInstaller);
        this.installButton = new JButton("Install");
        this.installButton.addActionListener(this);
        this.add(GuiUtils.createImagePanel("/logo.png"), 0, 0, 1.0, 1.0);
        this.add(GuiUtils.createTitledPanel(this.multimcDirectoryTextfield, "MultiMC / Prism Launcher Directory"), 0, 1, 1.0, 0.0);
        this.add(this.versionComponent, 0, 2, 1.0, 0.0);
        this.add(this.installButton, 0, 3, 1.0, 0.0);
    }

    @Override
    public boolean install() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        File multiMcFolder = new File(this.multimcDirectoryTextfield.getText());
        File instancesFolder = new File(multiMcFolder, "instances");
        parameters.put("instancesfolder", instancesFolder.getAbsolutePath());
        parameters.put("version", this.versionComponent.getSelectedVersion());
        return this.multiMCInstaller.install(parameters, (ProgressListener)new ProgressListener.Dummy());
    }
}

