/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern;

import b100.installer.Global;
import b100.installer.Sound;
import b100.installer.gui.modern.render.DefaultRenderer;
import b100.installer.gui.modern.render.FontRenderer;
import b100.installer.gui.modern.render.Renderer;
import b100.installer.gui.modern.screen.GuiMainMenu;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.screen.multimc.GuiInstallMultiMC;
import b100.installer.util.Crash;
import b100.installer.util.CrashHandler;
import b100.installer.util.MultiMCHelper;
import b100.installer.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InstallerGuiModern {
    private static InstallerGuiModern instance;
    private JFrame frame;
    private JPanel panel;
    public DefaultRenderer renderer;
    public GuiScreen screen;
    private Runnable tickHandler;
    private Listeners listeners;
    private volatile boolean repaint;
    private volatile boolean running;
    private boolean holdingShift;
    private boolean holdingAlt;
    private boolean holdingCtrl;
    private boolean cancelCharEvent;
    public volatile Crash crash;
    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static InstallerGuiModern getInstance() {
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    private InstallerGuiModern() {
        block8: {
            super();
            this.tickHandler = new TickHandler();
            this.listeners = new Listeners();
            this.repaint = false;
            this.running = false;
            this.holdingShift = false;
            this.holdingAlt = false;
            this.holdingCtrl = false;
            this.cancelCharEvent = false;
            this.uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Thread;Ljava/lang/Throwable;)V, lambda$0(java.lang.Thread java.lang.Throwable ), (Ljava/lang/Thread;Ljava/lang/Throwable;)V)((InstallerGuiModern)this);
            if (InstallerGuiModern.instance != null) {
                throw new IllegalStateException("Instance already exists!");
            }
            InstallerGuiModern.instance = this;
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.init();
                this.run();
                break block8;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    this.frame.dispose();
                }
                catch (Exception var2_3) {
                    // empty catch block
                }
                msg = new StringBuilder();
                msg.append("The installer has crashed!\n\n");
                infos = Utils.getInstallerAndSystemInfo();
                ** for (info : infos)
            }
lbl-1000:
            // 1 sources

            {
                msg.append(info).append('\n');
                continue;
            }
lbl38:
            // 1 sources

            msg.append('\n');
            CrashHandler.createErrorLog(msg, e);
            msg.append("\n\nThe full log has been saved at " + Global.getLogFile().getAbsolutePath());
            new CrashHandler(msg.toString(), null);
        }
    }

    private void init() {
        Sound.init();
        EventQueue.invokeLater(() -> Thread.currentThread().setUncaughtExceptionHandler(this.uncaughtExceptionHandler));
        this.renderer = new DefaultRenderer();
        Renderer.instance = this.renderer;
        FontRenderer.instance = new FontRenderer(this.renderer);
        this.initFrame();
        File instancesFolder = MultiMCHelper.getInstancesDirectory();
        if (instancesFolder != null) {
            System.out.println("Found Instances Folder: " + instancesFolder);
            this.setScreen(new GuiInstallMultiMC(null, instancesFolder));
        } else {
            this.setScreen(null);
        }
    }

    private void run() {
        int targetFPS = 60;
        int tickTime = 16;
        long totalDelta = 0L;
        this.running = true;
        while (this.running) {
            long tickStart = System.nanoTime();
            EventQueue.invokeLater(this.tickHandler);
            if (this.crash != null) {
                throw new RuntimeException("Exception in thread \"" + this.crash.thread.getName() + "\"", this.crash.cause);
            }
            long tickEnd = System.nanoTime();
            long delta = tickEnd - tickStart;
            long deltaMs = (totalDelta += delta) / 1000000L;
            totalDelta -= deltaMs * 1000000L;
            long sleep = 16L - deltaMs;
            if (sleep <= 0L) continue;
            try {
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initFrame() {
        this.frame = new JFrame();
        this.frame.setTitle("Installer");
        this.frame.setBackground(Color.black);
        this.panel = new DrawPanel();
        this.panel.setBackground(Color.black);
        this.panel.setPreferredSize(new Dimension(854, 480));
        this.panel.setFocusable(false);
        this.panel.setDoubleBuffered(true);
        this.panel.addMouseMotionListener(this.listeners);
        this.frame.setFocusTraversalKeysEnabled(false);
        this.frame.addKeyListener(this.listeners);
        this.panel.addMouseListener(this.listeners);
        this.frame.addWindowListener(this.listeners);
        this.frame.addMouseWheelListener(this.listeners);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setMinimumSize(new Dimension(320, 240));
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setVisible(true);
    }

    private void render(Component component, Graphics g) {
        if (g == null) {
            return;
        }
        this.repaint = false;
        this.renderer.update(component, g);
        if (this.screen != null) {
            if (!this.screen.isInitialized()) {
                this.screen.init();
            }
            int w = this.renderer.getWidth();
            int h = this.renderer.getHeight();
            if (w != this.screen.width || h != this.screen.height) {
                this.screen.setSize(w, h);
                this.screen.onResize();
            }
            this.screen.draw();
        }
    }

    public void setScreen(GuiScreen screen) {
        if (screen == null) {
            screen = new GuiMainMenu(null);
        }
        this.screen = screen;
        this.scheduleRepaint();
    }

    public boolean isShiftPressed() {
        return this.holdingShift;
    }

    public boolean isAltPressed() {
        return this.holdingAlt;
    }

    public boolean isCtrlPressed() {
        return this.holdingCtrl;
    }

    public void scheduleRepaint() {
        this.repaint = true;
    }

    private void mouseMoved(int x, int y) {
        if (this.screen != null) {
            double scale = this.renderer.getScale();
            double mouseX = (double)x / scale;
            double mouseY = (double)y / scale;
            this.screen.mouseX = mouseX;
            this.screen.mouseY = mouseY;
        }
    }

    private void mouseEvent(int x, int y, int button, boolean pressed) {
        if (this.screen != null) {
            double scale = this.renderer.getScale();
            double mouseX = (double)x / scale;
            double mouseY = (double)y / scale;
            this.screen.mouseX = mouseX;
            this.screen.mouseY = mouseY;
            if (this.screen.isInitialized()) {
                this.screen.mouseEvent(button, pressed, mouseX, mouseY);
            }
        }
    }

    private void keyEvent(int key, boolean pressed) {
        if (key == 16) {
            this.holdingShift = pressed;
        }
        if (key == 18) {
            this.holdingAlt = pressed;
        }
        if (key == 17) {
            this.holdingCtrl = pressed;
        }
        if (this.screen != null && this.screen.isInitialized()) {
            boolean ret = this.screen.keyEvent(key, pressed);
            if (pressed && ret) {
                this.cancelCharEvent = true;
            }
            if (!pressed) {
                this.cancelCharEvent = false;
            }
        }
    }

    private void charEvent(char c) {
        if (this.screen != null && this.screen.isInitialized() && !this.cancelCharEvent) {
            this.screen.charEvent(c);
        }
    }

    private void scrollEvent(double verticalAmount, int x, int y) {
        if (this.screen != null && this.screen.isInitialized()) {
            double scale = this.renderer.getScale();
            double mouseX = (double)x / scale;
            double mouseY = (double)y / scale;
            this.screen.scrollEvent(-verticalAmount, mouseX, mouseY);
        }
    }

    private void close() {
        this.running = false;
        this.frame.dispose();
    }

    public void onCrash(Throwable throwable) {
        this.crash = new Crash(throwable, Thread.currentThread());
    }

    public static void main(String[] args) {
        Global.setup(args);
        new InstallerGuiModern();
    }

    private /* synthetic */ void lambda$0(Thread t, Throwable e) {
        this.onCrash(e);
    }

    class DrawPanel
    extends JPanel {
        DrawPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            InstallerGuiModern.this.render(this, g);
        }
    }

    class Listeners
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener,
    WindowListener {
        Listeners() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            InstallerGuiModern.this.mouseMoved(e.getX(), e.getY());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            InstallerGuiModern.this.mouseMoved(e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            InstallerGuiModern.this.mouseEvent(e.getX(), e.getY(), e.getButton(), true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            InstallerGuiModern.this.mouseEvent(e.getX(), e.getY(), e.getButton(), false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            InstallerGuiModern.this.keyEvent(e.getKeyCode(), true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            InstallerGuiModern.this.keyEvent(e.getKeyCode(), false);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            InstallerGuiModern.this.close();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            InstallerGuiModern.this.scrollEvent(e.getPreciseWheelRotation(), e.getX(), e.getY());
        }

        @Override
        public void keyTyped(KeyEvent e) {
            InstallerGuiModern.this.charEvent(e.getKeyChar());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    class TickHandler
    implements Runnable {
        TickHandler() {
        }

        @Override
        public void run() {
            if (InstallerGuiModern.this.screen != null) {
                if (!InstallerGuiModern.this.screen.isInitialized()) {
                    InstallerGuiModern.this.screen.init();
                }
                InstallerGuiModern.this.screen.tick();
            }
            if (InstallerGuiModern.this.repaint) {
                InstallerGuiModern.this.panel.repaint();
            }
        }
    }
}

