/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.Sound;
import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;
import java.awt.image.BufferedImage;

public class GuiButton
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    public String text;
    protected boolean clickable = true;
    protected boolean focused = false;
    public final ListenerList<ActionListener> actionListeners = new ListenerList(this);
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    protected int state = 1;

    public GuiButton(GuiScreen screen, String text) {
        this.screen = screen;
        this.text = text;
        this.width = 200;
        this.height = 20;
    }

    @Override
    public void tick() {
        int newState = this.clickable ? (this.focused || this.screen.isMouseOver(this) ? 2 : 1) : 0;
        if (this.state != newState) {
            this.state = newState;
            InstallerGuiModern.getInstance().scheduleRepaint();
        }
    }

    @Override
    public void draw() {
        int fontColor;
        BufferedImage texture;
        if (this.state == 2) {
            texture = Textures.button_hover;
            fontColor = 0xFFFF80;
        } else if (this.state == 1) {
            texture = Textures.button;
            fontColor = 0xFFFFFF;
        } else {
            texture = Textures.button_disabled;
            fontColor = 0x808080;
        }
        int w1 = this.width / 2;
        int w2 = this.width - w1;
        this.renderer.drawSubImage(texture, this.posX, this.posY, w1, this.height, 0, 0);
        this.renderer.drawSubImage(texture, this.posX + w1, this.posY, w2, this.height, 200 - w2, 0);
        this.renderer.setColor(0xFF0000);
        if (this.text != null) {
            int textWidth = this.fontRenderer.getStringWidth(this.text);
            int textX = this.posX + (this.width - textWidth) / 2;
            int textY = this.posY + this.height / 2 - 4;
            this.fontRenderer.drawString(this.text, textX, textY, fontColor, true);
        }
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        if (pressed && this.focused && (key == 10 || key == 32)) {
            this.clickButton();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (this.clickable && pressed && this.screen.isMouseOver(this)) {
            this.clickButton();
            return true;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    public void clickButton() {
        Sound.click.play();
        this.actionListeners.forEach(listener -> listener.actionPerformed(this));
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.focusListeners.forEach(listener -> listener.focusChanged(this));
        }
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return this.clickable;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    public ListenerList<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public GuiButton addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
        return this;
    }

    public boolean removeActionListener(ActionListener actionListener) {
        return this.actionListeners.remove(actionListener);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + ",text=" + this.text + "]";
    }
}

