/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiContainer;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;

public class GuiDialog
extends GuiContainer {
    public boolean enabled = true;
    public GuiScreen screen;
    private boolean updated = true;
    private GuiBackground background = new GuiBackground(null);

    public GuiDialog(GuiScreen screen) {
        this.screen = screen;
    }

    @Override
    public void draw() {
        if (!this.enabled) {
            return;
        }
        if (this.updated) {
            this.updated = false;
            int innerPadding = 8;
            int outerPadding = 8;
            this.background.width = 0;
            this.background.height = 0;
            for (GuiElement element : this.elements) {
                this.background.width = Math.max(element.width, this.background.width);
                this.background.height += element.height;
            }
            this.background.width += 2 * outerPadding;
            this.background.height += 2 * outerPadding;
            this.background.height += (this.elements.size() - 1) * innerPadding;
            this.background.setSize(this.background.width, this.background.height);
            int x = (this.screen.width - this.background.width) / 2;
            int y = (this.screen.height - this.background.height) / 2;
            int yOffset = 0;
            int i = 0;
            while (i < this.elements.size()) {
                GuiElement element = (GuiElement)this.elements.get(i);
                int x1 = x + (this.background.width - element.width) / 2;
                int y1 = outerPadding + y + yOffset;
                element.setPosition(x1, y1);
                yOffset += element.height;
                yOffset += innerPadding;
                ++i;
            }
            this.background.setPosition(x, y);
        }
        this.setPosition(this.screen.posX, this.screen.posY);
        this.setSize(this.screen.width, this.screen.height);
        this.renderer.drawImageStretched(Textures.dialogBackground, this.posX, this.posY, this.width, this.height);
        this.renderer.setColor(-8355712);
        this.renderer.drawRectangleOutline(this.background.posX - 1, this.background.posY - 1, this.background.width + 2, this.background.height + 2);
        this.renderer.resetColor();
        this.background.draw();
        super.draw();
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (this.enabled) {
            if (pressed && this.screen.isMouseOver(this)) {
                this.close();
                return true;
            }
            return super.mouseEvent(button, pressed, mouseX, mouseY);
        }
        return false;
    }

    @Override
    public GuiElement getClickElementAt(double x, double y) {
        if (!this.enabled) {
            return null;
        }
        return super.getClickElementAt(x, y);
    }

    public void close() {
        this.enabled = false;
        InstallerGuiModern.getInstance().scheduleRepaint();
    }

    public void open() {
        this.enabled = true;
        InstallerGuiModern.getInstance().scheduleRepaint();
    }

    public boolean isOpened() {
        return this.enabled;
    }

    @Override
    public void onResize() {
        super.onResize();
        this.updated = true;
    }

    @Override
    public void onElementAdded(GuiElement element) {
        super.onElementAdded(element);
        this.updated = true;
    }

    @Override
    public boolean isSolid() {
        return this.enabled;
    }
}

