/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;

public class GuiListButton
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    private final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    public int outlineColorFocused = -1;
    public int outlineColor = -8355712;
    public int fillColor = -16777216;
    public String text;
    private boolean clickable = true;
    private boolean focused = false;

    public GuiListButton(GuiScreen screen) {
        this.screen = screen;
        this.width = 200;
        this.height = 20;
    }

    @Override
    public void draw() {
        int highlight = this.getHighlightColor();
        if (highlight != 0) {
            this.renderer.setColor(highlight);
            this.renderer.drawRectangle(this.posX, this.posY, this.width, this.height);
            this.renderer.setColor(this.fillColor);
            this.renderer.drawRectangle(this.posX + 1, this.posY + 1, this.width - 2, this.height - 2);
        }
        if (this.text != null) {
            int textWidth = this.fontRenderer.getStringWidth(this.text);
            int textX = this.posX + (this.width - textWidth) / 2;
            int textY = this.posY + this.height / 2 - 4;
            this.fontRenderer.drawString(this.text, textX, textY, 0xFFFFFF, true);
        }
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (pressed && this.screen.isMouseOver(this) && this.clickable) {
            this.setFocused(true);
            return true;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.onFocusChanged();
        }
    }

    public int getHighlightColor() {
        if (this.isFocused()) {
            return this.outlineColorFocused;
        }
        if (this.getContainer().getLastFocusedElement() == this) {
            return this.outlineColor;
        }
        return 0;
    }

    public void onFocusChanged() {
        InstallerGuiModern.getInstance().scheduleRepaint();
        this.focusListeners.forEach(e -> e.focusChanged(this));
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    public GuiListButton addFocusListener(FocusListener focusListener) {
        this.focusListeners.add(focusListener);
        return this;
    }

    public boolean removeFocusListener(FocusListener focusListener) {
        return this.focusListeners.remove(focusListener);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x=" + this.posX + ",y=" + this.posY + ",w=" + this.width + ",h=" + this.height + ",text=" + this.text + "]";
    }
}

