/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiContainer;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiElementShadow;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.FocusDirection;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.util.Utils;

public class GuiScrollableList
extends GuiContainer {
    public GuiScreen screen;
    public Layout layout;
    private double scrollAmount = 0.0;
    private double maxScrollAmount = 0.0;
    private int contentHeight;
    private int scrollRegionHeight;
    private boolean scrollAmountChanged = false;
    public boolean centerElements = true;
    public boolean useScissor = false;
    public int scissorBorder = 0;
    public int scrollToElementOffset = 4;

    public GuiScrollableList(GuiScreen screen) {
        this(screen, new ListLayout());
    }

    public GuiScrollableList(GuiScreen screen, Layout layout) {
        this.screen = screen;
        this.layout = layout;
        this.isList = true;
    }

    public GuiScrollableList createShadows(GuiContainer container) {
        container.add(new GuiElementShadow(this, Textures.shadow_2, GuiElementShadow.Position.IN_ELEMENT_TOP));
        container.add(new GuiElementShadow(this, Textures.shadow_1, GuiElementShadow.Position.IN_ELEMENT_BOTTOM));
        return this;
    }

    @Override
    public void tick() {
        this.setScrollAmount(this.scrollAmount);
        if (this.scrollAmountChanged) {
            this.scrollAmountChanged = false;
            this.layout.moveElements(this);
            InstallerGuiModern.getInstance().scheduleRepaint();
            super.onResize();
        }
        super.tick();
    }

    @Override
    public void draw() {
        if (this.useScissor) {
            this.renderer.enableScissor(this.posX - this.scissorBorder, this.posY - this.scissorBorder, this.width + 2 * this.scissorBorder, this.height + 2 * this.scissorBorder);
        }
        super.draw();
        if (this.useScissor) {
            this.renderer.disableScissor();
        }
    }

    @Override
    public void onResize() {
        this.scrollRegionHeight = this.getScrollRegionHeight();
        this.contentHeight = this.layout.getContentHeight(this);
        this.maxScrollAmount = Math.max(0.0, (double)(this.contentHeight - this.scrollRegionHeight));
        this.scrollAmount = Utils.clampd(this.scrollAmount, 0.0, this.maxScrollAmount);
        this.layout.moveElements(this);
        super.onResize();
    }

    @Override
    public boolean scrollEvent(double verticalAmount, double mouseX, double mouseY) {
        if (this.isInside(mouseX, mouseY)) {
            this.scroll(verticalAmount * 12.0);
            return true;
        }
        return false;
    }

    public void scroll(double amount) {
        this.setScrollAmount(this.scrollAmount - amount);
    }

    public void setScrollAmount(double newScrollAmount) {
        newScrollAmount = this.contentHeight < this.height ? (this.centerElements ? (double)(-(this.height - this.contentHeight) / 2) : 0.0) : Utils.clampd(newScrollAmount, 0.0, this.maxScrollAmount);
        if (newScrollAmount == this.scrollAmount) {
            return;
        }
        this.scrollAmount = newScrollAmount;
        this.scrollAmountChanged = true;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    public int getScrollRegionHeight() {
        return this.height;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollOffset() {
        return -Utils.floor(this.scrollAmount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public double getMaxScrollAmount() {
        return this.maxScrollAmount;
    }

    @Override
    public GuiElement getClickElementAt(double x, double y) {
        if (!this.isInside(x, y)) {
            return null;
        }
        return super.getClickElementAt(x, y);
    }

    @Override
    public Focusable getFirstFocusableElement(FocusDirection direction) {
        Focusable lastFocusedElement = this.getLastFocusedElement();
        if (lastFocusedElement != null && direction.isTab()) {
            return lastFocusedElement;
        }
        return super.getFirstFocusableElement(direction);
    }

    @Override
    public Focusable getNextFocusable(GuiElement element, FocusDirection direction) {
        return super.getNextFocusable(element, direction);
    }

    @Override
    public void onElementAdded(GuiElement element) {
        super.onElementAdded(element);
    }

    @Override
    public void onElementRemoved(GuiElement element) {
        super.onElementRemoved(element);
    }

    @Override
    public void focusChanged(Focusable focusable) {
        this.scrollToElement(focusable);
        super.focusChanged(focusable);
    }

    public boolean scrollToElement(Focusable focusable) {
        if (focusable == null) {
            return false;
        }
        GuiElement element = (GuiElement)((Object)focusable);
        if (focusable.isFocused() && this.contains(element)) {
            int offset = 0;
            if (element.posY < this.posY) {
                offset = this.posY - element.posY + this.scrollToElementOffset;
            }
            if (element.posY + element.height > this.posY + this.height) {
                offset = this.posY + this.height - element.posY - element.height - this.scrollToElementOffset;
            }
            if (offset != 0) {
                this.scroll(offset);
            }
            return true;
        }
        return false;
    }

    public static interface Layout {
        public void moveElements(GuiScrollableList var1);

        public int getContentHeight(GuiScrollableList var1);

        public int getContentWidth(GuiScrollableList var1);
    }

    public static class ListLayout
    implements Layout {
        public int outerPadding = 5;
        public int innerPadding = 0;
        public Align align = Align.CENTER;

        @Override
        public void moveElements(GuiScrollableList list) {
            int offset = list.getScrollOffset();
            offset += this.outerPadding;
            int i = 0;
            while (i < list.elements.size()) {
                GuiElement element = (GuiElement)list.elements.get(i);
                int x = this.align == Align.LEFT ? list.posX + this.outerPadding : (this.align == Align.CENTER ? list.posX + list.width / 2 - element.width / 2 : list.posX + list.width - element.width - this.outerPadding);
                element.setPosition(x, list.posY + offset);
                offset += element.height;
                offset += this.innerPadding;
                ++i;
            }
        }

        @Override
        public int getContentHeight(GuiScrollableList list) {
            int contentHeight = 0;
            int i = 0;
            while (i < list.elements.size()) {
                contentHeight += ((GuiElement)list.elements.get((int)i)).height;
                ++i;
            }
            contentHeight += 2 * this.outerPadding;
            return contentHeight += (list.elements.size() - 1) * this.innerPadding;
        }

        @Override
        public int getContentWidth(GuiScrollableList list) {
            int contentWidth = 0;
            int i = 0;
            while (i < list.elements.size()) {
                contentWidth = Math.max(contentWidth, ((GuiElement)list.elements.get((int)i)).width);
                ++i;
            }
            return contentWidth += 2 * this.outerPadding;
        }

        public static enum Align {
            LEFT,
            CENTER,
            RIGHT;

        }
    }
}

