/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.element.GuiElement;
import b100.installer.util.Utils;
import java.util.List;

public class GuiTextElement
extends GuiElement {
    protected List<String> lines;
    protected double alignX = 0.0;
    protected double alignY = 0.0;
    protected int textWidth;
    protected int textHeight;
    protected int textColor = 0xFFFFFF;
    protected boolean autoSize = false;

    public GuiTextElement() {
        this.setSize(8, 8);
    }

    public GuiTextElement(String text, double alignX, double alignY) {
        this();
        this.setAlign(alignX, alignY);
        this.setText(text);
    }

    @Override
    public void draw() {
        if (this.lines == null) {
            return;
        }
        if (this.autoSize) {
            this.width = this.textWidth;
            this.height = this.textHeight;
        }
        int textPosX = (int)((double)this.posX + (double)(this.width - this.textWidth) * this.alignX);
        int textPosY = (int)((double)this.posY + (double)(this.height - this.textHeight) * this.alignY);
        int lineNumber = 0;
        while (lineNumber < this.lines.size()) {
            String line = this.lines.get(lineNumber);
            this.fontRenderer.drawString(line, textPosX, textPosY + lineNumber * 9, this.textColor);
            ++lineNumber;
        }
    }

    public void setAlignX(double alignX) {
        this.alignX = alignX;
    }

    public void setAlignY(double alignY) {
        this.alignY = alignY;
    }

    public GuiTextElement setAlign(double alignX, double alignY) {
        this.alignX = alignX;
        this.alignY = alignY;
        return this;
    }

    public GuiTextElement setText(String text) {
        if (text == null) {
            this.lines = null;
            return this;
        }
        this.lines = Utils.splitLines(text);
        int maxLineWidth = 0;
        for (String line : this.lines) {
            maxLineWidth = Math.max(maxLineWidth, this.fontRenderer.getStringWidth(line));
        }
        this.textWidth = maxLineWidth;
        this.textHeight = this.lines.size() * 8 + this.lines.size() - 1;
        if (this.autoSize) {
            this.width = this.textWidth;
            this.height = this.textHeight;
        }
        return this;
    }

    public GuiTextElement setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiTextElement setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        if (autoSize) {
            this.width = this.textWidth;
            this.height = this.textHeight;
        }
        return this;
    }

    public double getAlignX() {
        return this.alignX;
    }

    public double getAlignY() {
        return this.alignY;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public boolean isAutoSizeEnabled() {
        return this.autoSize;
    }
}

