/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.element;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;
import b100.installer.util.Utils;

public class GuiTextField
extends GuiElement
implements Focusable {
    public GuiScreen screen;
    protected String text = "";
    public int textColor = 0xFFFFFF;
    public int cursorPosition;
    public int selection = -1;
    public long clickTime;
    public boolean focused;
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);
    protected boolean cursorVisible;

    public GuiTextField(GuiScreen screen) {
        this.screen = screen;
        this.setSize(200, 18);
    }

    @Override
    public void tick() {
        boolean blink;
        int blinkTime = 600;
        boolean bl = blink = (System.currentTimeMillis() - this.clickTime) % (long)blinkTime < (long)(blinkTime / 2);
        if (blink != this.cursorVisible) {
            this.cursorVisible = blink;
            InstallerGuiModern.getInstance().scheduleRepaint();
        }
        super.tick();
    }

    @Override
    public void draw() {
        int w;
        this.renderer.setColor(this.focused ? 0xFFFFFF : 0x808080);
        this.renderer.drawRectangle(this.posX - 1, this.posY - 1, this.width + 2, this.height + 2);
        this.renderer.setColor(0);
        this.renderer.drawRectangle(this.posX, this.posY, this.width, this.height);
        this.renderer.resetColor();
        int x = this.posX + 4;
        int y = this.posY + this.height / 2 - 4;
        this.cursorPosition = Utils.clampi(this.cursorPosition, 0, this.text.length());
        if (this.isTextSelected()) {
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            String str1 = this.text.substring(0, selectionStart);
            String str2 = this.text.substring(selectionStart, selectionEnd);
            String str3 = this.text.substring(selectionEnd, this.text.length());
            int w1 = this.fontRenderer.getStringWidth(str1);
            int w2 = this.fontRenderer.getStringWidth(str2);
            int x1 = x + w1;
            int w3 = this.fontRenderer.getStringWidth(this.text.substring(selectionStart, selectionEnd));
            int selectedTextColor = 0xFFFF00;
            if (!this.renderer.areBlendModesSupported()) {
                selectedTextColor = 255;
                this.renderer.setColor(0xFFFFFF);
                this.renderer.drawRectangle(x1, y - 1, w3, 10);
            }
            this.fontRenderer.drawString(str1, x, y, this.textColor);
            this.fontRenderer.drawString(str2, x + w1, y, selectedTextColor);
            this.fontRenderer.drawString(str3, x + w1 + w2, y, this.textColor);
            if (this.renderer.areBlendModesSupported()) {
                this.renderer.setInvertColorBlendMode();
                this.renderer.setColor(0xFFFFFF);
                this.renderer.drawRectangle(x1, y - 1, w3, 10);
                this.renderer.resetBlendMode();
            }
        } else {
            this.fontRenderer.drawString(this.text, x, y, this.textColor);
        }
        if (this.cursorPosition == this.text.length()) {
            if (this.focused && this.cursorVisible) {
                w = this.fontRenderer.getStringWidth(this.text);
                this.fontRenderer.drawString("_", x + w, y, this.textColor);
            }
        } else if (this.focused && this.cursorVisible) {
            w = this.fontRenderer.getStringWidth(this.text.substring(0, this.cursorPosition));
            this.renderer.drawRectangle(x + w - 1, y - 1, 1, 10);
        }
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (pressed) {
            if (this.screen.isMouseOver(this)) {
                if (button == 3) {
                    this.setText("");
                    this.onTextOrCursorChanged();
                }
                if (!this.isFocused()) {
                    this.setFocused(true);
                }
                return true;
            }
            if (this.isFocused()) {
                this.setFocused(false);
            }
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        if (!this.focused) {
            return false;
        }
        if (pressed && this.editKeyEvent(key)) {
            return true;
        }
        return super.keyEvent(key, pressed);
    }

    @Override
    public boolean charEvent(char c) {
        if (!this.focused) {
            return false;
        }
        if (this.editCharEvent(c)) {
            return true;
        }
        return super.charEvent(c);
    }

    protected boolean editKeyEvent(int key) {
        boolean ctrl = InstallerGuiModern.getInstance().isCtrlPressed();
        boolean shift = InstallerGuiModern.getInstance().isShiftPressed();
        if (key == 8) {
            if (this.isTextSelected()) {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                this.text = String.valueOf(this.text.substring(0, selStart)) + this.text.substring(selEnd);
                this.cursorPosition = selStart;
            } else if (this.cursorPosition > 0) {
                this.text = String.valueOf(this.text.substring(0, this.cursorPosition - 1)) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
            }
            this.onTextOrCursorChanged();
            return true;
        }
        if (key == 37 || key == 39 || key == 36 || key == 35) {
            if (shift && this.selection == -1) {
                this.selection = this.cursorPosition;
            }
            if (!shift) {
                this.selection = -1;
            }
            if (ctrl) {
                if (key == 37) {
                    this.cursorPosition = this.getNextWordIndex(-1);
                }
                if (key == 39) {
                    this.cursorPosition = this.getNextWordIndex(1);
                }
            } else {
                if (key == 37) {
                    --this.cursorPosition;
                }
                if (key == 39) {
                    ++this.cursorPosition;
                }
            }
            if (key == 36) {
                this.cursorPosition = 0;
            }
            if (key == 35) {
                this.cursorPosition = this.text.length();
            }
            this.onTextOrCursorChanged();
            return true;
        }
        if (ctrl) {
            if (key == 65) {
                if (this.text.length() > 0) {
                    this.selection = 0;
                    this.cursorPosition = this.text.length();
                    this.onTextOrCursorChanged();
                }
                return true;
            }
            if (key == 86) {
                String clipboard = this.removeInvalidCharacters(Utils.getClipboardString());
                if (clipboard != null && clipboard.length() > 0) {
                    if (this.selection != -1) {
                        int selStart = this.getSelectionStart();
                        int selEnd = this.getSelectionEnd();
                        this.text = String.valueOf(this.text.substring(0, selStart)) + clipboard + this.text.substring(selEnd);
                        this.cursorPosition = selStart + clipboard.length();
                    } else {
                        this.text = String.valueOf(this.text.substring(0, this.cursorPosition)) + clipboard + this.text.substring(this.cursorPosition);
                        this.cursorPosition += clipboard.length();
                    }
                    this.selection = -1;
                    this.onTextOrCursorChanged();
                }
                return true;
            }
            if (key == 67 && this.isTextSelected()) {
                Utils.copyString(this.text.substring(this.getSelectionStart(), this.getSelectionEnd()));
                return true;
            }
        }
        return false;
    }

    private int getNextWordIndex(int dir) {
        if ((dir = Utils.clampi(dir, -1, 1)) == 0) {
            return this.cursorPosition;
        }
        int i = this.cursorPosition + dir;
        while (i > 0 && i < this.text.length()) {
            if (this.text.charAt(i) != ' ' && this.text.charAt(i - 1) == ' ') {
                return i;
            }
            i += dir;
        }
        return dir > 0 ? this.text.length() : 0;
    }

    private String removeInvalidCharacters(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (this.isCharacterAllowed(c)) {
                str.append(c);
            }
            ++i;
        }
        return str.toString();
    }

    private boolean isCharacterAllowed(char c) {
        return c != '\n' && c != '\u0000';
    }

    protected boolean editCharEvent(char c) {
        if (this.isCharacterAllowed(c)) {
            if (this.isTextSelected()) {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                this.text = String.valueOf(this.text.substring(0, selStart)) + c + this.text.substring(selEnd);
                this.selection = -1;
                this.cursorPosition = selStart + 1;
            } else {
                this.text = String.valueOf(this.text.substring(0, this.cursorPosition)) + c + this.text.substring(this.cursorPosition);
                ++this.cursorPosition;
            }
            this.onTextOrCursorChanged();
        }
        return true;
    }

    protected void onTextOrCursorChanged() {
        this.clickTime = System.currentTimeMillis();
        if (this.text.length() == 0) {
            this.selection = -1;
            this.cursorPosition = 0;
        }
        InstallerGuiModern.getInstance().scheduleRepaint();
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            InstallerGuiModern.getInstance().scheduleRepaint();
            if (focused) {
                if (this.clickTime == 0L) {
                    this.clickTime = System.currentTimeMillis();
                }
            } else {
                this.clickTime = 0L;
            }
            this.focusListeners.forEach(e -> e.focusChanged(this));
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.cursorPosition = text.length();
        this.selection = -1;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public ListenerList<FocusListener> getFocusListeners() {
        return this.focusListeners;
    }

    public boolean isTextSelected() {
        return this.selection != -1;
    }

    public int getSelectionStart() {
        if (!this.isTextSelected()) {
            return -1;
        }
        return Math.min(this.selection, this.cursorPosition);
    }

    public int getSelectionEnd() {
        if (!this.isTextSelected()) {
            return -1;
        }
        return Math.max(this.selection, this.cursorPosition);
    }
}

