/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.render;

import b100.installer.gui.modern.render.BlendComposite;
import b100.installer.gui.modern.render.Renderer;
import b100.installer.gui.modern.render.Textures;
import b100.installer.util.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class DefaultRenderer
extends Renderer {
    private Graphics2D g;
    private int scale = 1;
    private int scaledWidth;
    private int scaledHeight;
    private int color;
    private Map<BufferedImage, Map<Integer, BufferedImage>> tintedImageCache = new HashMap<BufferedImage, Map<Integer, BufferedImage>>();
    private boolean scissorEnabled = false;
    private int scissorX;
    private int scissorY;
    private int scissorWidth;
    private int scissorHeight;

    public void update(Component component, Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException("Graphics is null!");
        }
        this.g = (Graphics2D)graphics;
        int width = component.getWidth();
        int height = component.getHeight();
        this.scale = Math.max(1, Math.min(width / 320, height / 240));
        this.scaledWidth = Math.max(1, Utils.ceilDiv(width, this.scale));
        this.scaledHeight = Math.max(1, Utils.ceilDiv(height, this.scale));
    }

    @Override
    public int getWidth() {
        return this.scaledWidth;
    }

    @Override
    public int getHeight() {
        return this.scaledHeight;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void drawImage(BufferedImage image, int x, int y) {
        if (image == null) {
            image = Textures.missingtex;
        }
        this.drawSubImage(image, x, y, image.getWidth(), image.getHeight(), 0, 0);
    }

    @Override
    public void drawImageStretched(BufferedImage image, int x, int y, int w, int h) {
        if (image == null) {
            image = Textures.missingtex;
        }
        image = this.getTintedImage(image, this.color);
        this.g.drawImage(image, x * this.scale, y * this.scale, w * this.scale, h * this.scale, null);
    }

    @Override
    public void drawSubImage(BufferedImage image, int x, int y, int w, int h, int sx, int sy) {
        if (image == null) {
            image = Textures.missingtex;
        }
        image = this.getTintedImage(image, this.color);
        if (this.scissorEnabled) {
            int offset;
            if (this.isOutsideScissorArea(x, y, w, h)) {
                return;
            }
            if (x < this.scissorX) {
                offset = this.scissorX - x;
                x += offset;
                sx += offset;
                w -= offset;
            }
            if (x + w >= this.scissorX + this.scissorWidth) {
                offset = x + w - (this.scissorX + this.scissorWidth);
                w -= offset;
            }
            if (y < this.scissorY) {
                offset = this.scissorY - y;
                y += offset;
                sy += offset;
                h -= offset;
            }
            if (y + h >= this.scissorY + this.scissorHeight) {
                offset = y + h - (this.scissorY + this.scissorHeight);
                h -= offset;
            }
        }
        this.g.drawImage(image, x * this.scale, y * this.scale, (x + w) * this.scale, (y + h) * this.scale, sx, sy, sx + w, sy + h, null);
    }

    @Override
    public void drawRectangle(int x, int y, int w, int h) {
        if (this.scissorEnabled) {
            int offset;
            if (this.isOutsideScissorArea(x, y, w, h)) {
                return;
            }
            if (x < this.scissorX) {
                offset = this.scissorX - x;
                x += offset;
                w -= offset;
            }
            if (x + w >= this.scissorX + this.scissorWidth) {
                offset = x + w - (this.scissorX + this.scissorWidth);
                w -= offset;
            }
            if (y < this.scissorY) {
                offset = this.scissorY - y;
                y += offset;
                h -= offset;
            }
            if (y + h >= this.scissorY + this.scissorHeight) {
                offset = y + h - (this.scissorY + this.scissorHeight);
                h -= offset;
            }
        }
        this.g.fillRect(x * this.scale, y * this.scale, w * this.scale, h * this.scale);
    }

    @Override
    public void setColor(int color) {
        this.color = color;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        this.g.setColor(new Color(red, green, blue));
    }

    @Override
    public void enableScissor(int x, int y, int w, int h) {
        this.scissorEnabled = true;
        this.scissorX = x;
        this.scissorY = y;
        this.scissorWidth = w;
        this.scissorHeight = h;
    }

    @Override
    public void disableScissor() {
        this.scissorEnabled = false;
    }

    public boolean isOutsideScissorArea(int x, int y, int w, int h) {
        if (x + w < this.scissorX) {
            return true;
        }
        if (y + h < this.scissorY) {
            return true;
        }
        if (x >= this.scissorX + this.scissorWidth) {
            return true;
        }
        return y >= this.scissorY + this.scissorHeight;
    }

    @Override
    public boolean areBlendModesSupported() {
        return Utils.OPERATING_SYSTEM != 2;
    }

    @Override
    public void resetBlendMode() {
        this.g.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void setInvertColorBlendMode() {
        if (this.areBlendModesSupported()) {
            this.g.setComposite(BlendComposite.Negation);
        }
    }

    public static BufferedImage loadTexture(String path) {
        InputStream in = null;
        try {
            in = Utils.class.getResourceAsStream(path);
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (Exception e) {
            System.out.println("Could not load texture: " + path);
            BufferedImage bufferedImage = Textures.missingtex;
            return bufferedImage;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private BufferedImage getTintedImage(BufferedImage image, int colorMultiplier) {
        BufferedImage coloredImage;
        if ((colorMultiplier |= 0xFF000000) == -1) {
            return image;
        }
        Map<Integer, BufferedImage> imageColors = this.tintedImageCache.get(image);
        if (imageColors == null) {
            imageColors = new HashMap<Integer, BufferedImage>();
            this.tintedImageCache.put(image, imageColors);
        }
        if ((coloredImage = imageColors.get(colorMultiplier)) == null) {
            System.out.println("Creating tinted image: " + image.getWidth() + " x " + image.getHeight() + " : " + Integer.toString(colorMultiplier & 0xFFFFFF, 16));
            coloredImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            imageColors.put(colorMultiplier, coloredImage);
            float rmul = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float gmul = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float bmul = (float)(colorMultiplier >> 0 & 0xFF) / 255.0f;
            int x = 0;
            while (x < image.getWidth()) {
                int y = 0;
                while (y < image.getHeight()) {
                    int rgb = image.getRGB(x, y);
                    int a = rgb >> 24 & 0xFF;
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb >> 0 & 0xFF;
                    r = Utils.clampi((int)((float)r * rmul), 0, 255);
                    g = Utils.clampi((int)((float)g * gmul), 0, 255);
                    b = Utils.clampi((int)((float)b * bmul), 0, 255);
                    coloredImage.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
        }
        return coloredImage;
    }
}

