/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.render;

import b100.installer.gui.modern.render.Renderer;
import b100.installer.gui.modern.render.Textures;
import b100.installer.util.Utils;
import java.awt.image.BufferedImage;

public class FontRenderer {
    public static FontRenderer instance;
    public Renderer renderer;
    private byte[] charWidths;

    public FontRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.initializeCharacterSizes();
    }

    private void initializeCharacterSizes() {
        this.charWidths = new byte[256];
        BufferedImage font = Textures.font;
        int charSize = 8;
        int charIndex = 0;
        while (charIndex < 256) {
            int charX = charIndex & 0xF;
            int charY = charIndex >> 4;
            int width = 0;
            if (charIndex == 32) {
                this.charWidths[charIndex] = 5;
            } else if (charIndex < 32 || charIndex >= 176 && charIndex < 255) {
                this.charWidths[charIndex] = 8;
            } else {
                int i = 0;
                while (i < 8) {
                    int j = 0;
                    while (j < 8) {
                        int px = charX * 8 + i;
                        int py = charY * 8 + j;
                        int color = font.getRGB(px, py);
                        int alpha = color >> 24 & 0xFF;
                        if (alpha > 0) {
                            width = Math.max(width, i);
                        }
                        ++j;
                    }
                    ++i;
                }
                this.charWidths[charIndex] = (byte)(width + 2);
            }
            ++charIndex;
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, 0xFFFFFF, true);
    }

    public void drawCenteredString(String string, int x, int y, int color, boolean shadow) {
        int width = this.getStringWidth(string);
        this.drawString(string, x - width / 2, y, color, shadow);
    }

    public void drawString(String string, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawString(string, x + 1, y + 1, Utils.multiplyRGB(color, 0.25));
        }
        this.drawString(string, x, y, color);
    }

    public void drawString(String string, int x, int y, int color) {
        this.renderer.setColor(color);
        int initialX = x;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\n') {
                x = initialX;
                y += 8;
            } else if (c == ' ') {
                x += this.getCharacterWidth(c);
            } else {
                this.drawCharacter(c, x, y);
                x += this.getCharacterWidth(c);
            }
            ++i;
        }
        this.renderer.setColor(0xFFFFFF);
    }

    public int getStringWidth(String string) {
        int width = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            width = c == '\n' ? 0 : (width += this.getCharacterWidth(c));
            ++i;
        }
        return width;
    }

    public void drawCharacter(char c, int x, int y) {
        int ic = c;
        ic = Math.min(ic, 255);
        int cx = ic & 0xF;
        int cy = ic >> 4;
        this.renderer.drawSubImage(Textures.font, x, y, 8, 8, cx * 8, cy * 8);
    }

    public int getCharacterWidth(char c) {
        return this.charWidths[Math.min(c, this.charWidths.length - 1)];
    }
}

