/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.render;

import b100.installer.gui.modern.render.DefaultRenderer;
import b100.installer.util.Utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Textures {
    public static BufferedImage missingtex = Textures.createMissingTexture();
    public static BufferedImage background = Textures.scale(Textures.loadTexture("background"), 2);
    public static BufferedImage button = Textures.loadTexture("button");
    public static BufferedImage button_disabled = Textures.loadTexture("button_disabled");
    public static BufferedImage button_hover = Textures.loadTexture("button_hover");
    public static BufferedImage font = Textures.loadTexture("font");
    public static BufferedImage logo = Textures.loadTexture("logo1");
    public static BufferedImage checkmark = Textures.loadTexture("checkmark");
    public static BufferedImage icons = Textures.loadTexture("icons");
    public static BufferedImage shadow_1 = Textures.createGradientImage(1, 6, 0, Integer.MIN_VALUE, false);
    public static BufferedImage shadow_2 = Textures.createGradientImage(1, 6, Integer.MIN_VALUE, 0, false);
    public static BufferedImage dialogBackground = Textures.createColorImage(-938471408);

    static {
        System.out.println("Loaded Textures!");
    }

    private static BufferedImage loadTexture(String name) {
        BufferedImage tex = DefaultRenderer.loadTexture("/resources/images/" + name + ".png");
        BufferedImage tex1 = new BufferedImage(tex.getWidth(), tex.getHeight(), 2);
        Graphics g = tex1.getGraphics();
        g.drawImage(tex, 0, 0, null);
        g.dispose();
        return tex1;
    }

    private static BufferedImage createMissingTexture() {
        BufferedImage missingTex = new BufferedImage(64, 64, 1);
        Graphics g = missingTex.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, missingTex.getWidth(), missingTex.getHeight());
        g.setColor(Color.black);
        g.drawString("missingtex", 0, 12);
        g.dispose();
        return missingTex;
    }

    private static BufferedImage createColorImage(int color) {
        return Textures.createColorImage(1, 1, color);
    }

    private static BufferedImage createColorImage(int width, int height, int color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int i = 0;
        while (i < image.getWidth()) {
            int j = 0;
            while (j < image.getHeight()) {
                image.setRGB(i, j, color);
                ++j;
            }
            ++i;
        }
        return image;
    }

    private static BufferedImage createGradientImage(int width, int height, int color1, int color2, boolean horizontal) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int i = 0;
        while (i < image.getWidth()) {
            int j = 0;
            while (j < image.getHeight()) {
                float factor = horizontal ? (float)i / (float)(image.getWidth() - 1) : (float)j / (float)(image.getHeight() - 1);
                image.setRGB(i, j, Utils.mixARGB(color1, color2, factor));
                ++j;
            }
            ++i;
        }
        return image;
    }

    private static BufferedImage scale(BufferedImage image, int scale) {
        BufferedImage scaledImage = new BufferedImage(image.getWidth() * scale, image.getHeight() * scale, image.getType());
        Graphics g = scaledImage.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth() * scale, image.getHeight() * scale, null);
        g.dispose();
        return scaledImage;
    }
}

