/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiListButton;
import b100.installer.gui.modern.element.GuiScrollBar;
import b100.installer.gui.modern.element.GuiScrollableList;
import b100.installer.gui.modern.element.GuiTextField;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.util.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.filechooser.FileSystemView;

public class GuiFileChooser
extends GuiScreen {
    public GuiScrollableList rootList;
    public GuiScrollableList currentDirectoryList;
    public GuiScrollBar currentDirectoryListScrollBar;
    public Button buttonBack;
    public Button buttonParentDirectory;
    public Button buttonCancel;
    public Button buttonOpen;
    private List<File> previousDirectories = new ArrayList<File>();
    private File currentDirectory = null;
    private File selectedFile = null;
    public GuiTextField pathTextField;
    public Function<File, Boolean> fileFilter;

    public GuiFileChooser(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    protected void onInit() {
        this.add(new GuiBackground(this));
        this.pathTextField = this.add(new GuiTextField(this));
        ActionListener actionListener = this.getInternalActionListener();
        this.buttonBack = this.add(new Button(this, 0, 0));
        this.buttonBack.addActionListener(actionListener);
        this.buttonBack.setClickable(false);
        this.buttonParentDirectory = this.add(new Button(this, 2, 0));
        this.buttonParentDirectory.addActionListener(actionListener);
        this.buttonParentDirectory.setClickable(false);
        ArrayList<File> rootFilesList = new ArrayList<File>();
        rootFilesList.add(FileSystemView.getFileSystemView().getHomeDirectory());
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rootFile = fileArray[n2];
            rootFilesList.add(rootFile);
            ++n2;
        }
        this.rootList = new FileList(this);
        int i = 0;
        while (i < rootFilesList.size()) {
            File rootFile = (File)rootFilesList.get(i);
            FileElement fileElement = new FileElement(this, rootFile);
            this.rootList.add(fileElement);
            ++i;
        }
        this.currentDirectoryList = new FileList(this);
        this.add(this.rootList);
        this.add(this.currentDirectoryList);
        this.currentDirectoryListScrollBar = new GuiScrollBar(this, this.currentDirectoryList);
        this.add(this.currentDirectoryListScrollBar);
        this.buttonCancel = this.add(new Button(this, "Cancel"));
        this.buttonCancel.addActionListener(actionListener);
        this.buttonOpen = this.add(new Button(this, "Choose Folder"));
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        if (pressed) {
            File file;
            if (this.pathTextField.isFocused() && key == 10 && (file = new File(this.pathTextField.getText())).isDirectory()) {
                this.setDirectory(file, true, false);
            }
            if (InstallerGuiModern.getInstance().isAltPressed() && key == 38) {
                this.directoryUp();
                return true;
            }
        }
        if (super.keyEvent(key, pressed)) {
            return true;
        }
        if (pressed && key == 8) {
            this.directoryBack();
            return true;
        }
        return false;
    }

    public boolean directoryBack() {
        if (this.previousDirectories.size() > 0) {
            this.setDirectory(this.previousDirectories.remove(0), false, false);
            return true;
        }
        return false;
    }

    public boolean directoryUp() {
        File parent;
        if (this.currentDirectory != null && (parent = this.currentDirectory.getAbsoluteFile().getParentFile()) != null) {
            this.setDirectory(parent, true, false);
            return true;
        }
        return false;
    }

    @Override
    public void draw() {
        super.draw();
    }

    @Override
    public void onResize() {
        int outerPadding = 12;
        int innerPadding = 6;
        int h0 = 12;
        int y0 = outerPadding;
        int y1 = y0 + h0 + innerPadding;
        int y2 = this.height - outerPadding - 10 - innerPadding;
        int h1 = y2 - y1 - innerPadding;
        int h2 = 14;
        this.buttonParentDirectory.setPosition(this.width - outerPadding - h0, y0).setSize(h0, h0);
        this.buttonBack.setPosition(this.buttonParentDirectory.posX - h0 - innerPadding, y0).setSize(h0, h0);
        this.rootList.setPosition(outerPadding, y1);
        this.rootList.setSize(100, h1);
        this.currentDirectoryList.setPosition(outerPadding + this.rootList.width + innerPadding, y1);
        this.currentDirectoryList.setSize(this.width - this.rootList.width - 2 * outerPadding - innerPadding, h1);
        this.currentDirectoryListScrollBar.setPosition(this.currentDirectoryList.posX + this.currentDirectoryList.width - this.currentDirectoryListScrollBar.width, this.currentDirectoryList.posY);
        this.currentDirectoryListScrollBar.setSize(6, this.currentDirectoryList.height);
        int i = 0;
        while (i < this.currentDirectoryList.elements.size()) {
            ((GuiElement)this.currentDirectoryList.elements.get((int)i)).width = this.currentDirectoryList.width - this.currentDirectoryListScrollBar.width - 1;
            ++i;
        }
        this.buttonCancel.setSize(this.fontRenderer.getStringWidth(this.buttonCancel.text) + 10, h2);
        this.buttonCancel.setPosition(this.width - outerPadding - this.buttonCancel.width, y2);
        this.buttonOpen.setSize(this.fontRenderer.getStringWidth(this.buttonOpen.text) + 10, h2);
        this.buttonOpen.setPosition(this.buttonCancel.posX - innerPadding - this.buttonOpen.width, y2);
        this.pathTextField.setPosition(outerPadding, y0).setSize(this.width - 2 * outerPadding - 2 * h0 - 2 * innerPadding, h0);
        super.onResize();
    }

    public boolean setDirectory(File directory, boolean addToPreviousDirectories, boolean focusFirstElement) {
        if (!directory.isDirectory()) {
            return false;
        }
        if (directory.equals(this.currentDirectory)) {
            return false;
        }
        if (this.currentDirectory != null && addToPreviousDirectories && (this.previousDirectories.size() == 0 || !this.previousDirectories.get(0).equals(this.currentDirectory))) {
            this.previousDirectories.add(0, this.currentDirectory);
        }
        this.currentDirectory = directory;
        this.pathTextField.setText(directory.getAbsolutePath());
        this.currentDirectoryList.removeAll();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory != null) {
            Arrays.sort(filesInDirectory, new FileComparator());
            int i = 0;
            while (i < filesInDirectory.length) {
                File file = filesInDirectory[i];
                if (this.fileFilter == null || this.fileFilter.apply(file).booleanValue()) {
                    FileElement element = new FileElement(this, file);
                    this.currentDirectoryList.add(element);
                    if (focusFirstElement && i == 0) {
                        element.setFocused(true);
                    }
                }
                ++i;
            }
        }
        this.buttonParentDirectory.setClickable(this.currentDirectory.getAbsoluteFile().getParentFile() != null);
        this.buttonBack.setClickable(this.previousDirectories.size() > 0);
        this.onResize();
        InstallerGuiModern.getInstance().scheduleRepaint();
        return true;
    }

    public File getSelectedFile() {
        if (this.selectedFile == null) {
            return this.currentDirectory;
        }
        return this.selectedFile;
    }

    protected ActionListener getInternalActionListener() {
        return new ActionListenerImpl();
    }

    protected class ActionListenerImpl
    implements ActionListener {
        protected ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(GuiElement source) {
            if (source == GuiFileChooser.this.buttonBack) {
                GuiFileChooser.this.directoryBack();
            }
            if (source == GuiFileChooser.this.buttonParentDirectory) {
                GuiFileChooser.this.directoryUp();
            }
            if (source == GuiFileChooser.this.buttonCancel) {
                GuiFileChooser.this.back();
            }
        }
    }

    protected static class Button
    extends GuiButton {
        public int iconX;
        public int iconY;

        public Button(GuiScreen screen, String text) {
            super(screen, text);
            this.iconX = -1;
            this.iconY = -1;
        }

        public Button(GuiScreen screen, int iconX, int iconY) {
            super(screen, null);
            this.iconX = iconX;
            this.iconY = iconY;
        }

        @Override
        public void draw() {
            int outlineColor;
            int iconColor = 0xFFFFFF;
            if (this.state == 2) {
                outlineColor = 0xFFFFFF;
            } else if (this.state == 1) {
                outlineColor = 0x808080;
            } else {
                outlineColor = 0x404040;
                iconColor = 0x404040;
            }
            this.renderer.setColor(outlineColor);
            this.renderer.drawRectangleOutline(this.posX - 1, this.posY - 1, this.width + 2, this.height + 2);
            this.renderer.setColor(0);
            this.renderer.drawRectangle(this.posX, this.posY, this.width, this.height);
            if (this.iconX >= 0 && this.iconY >= 0) {
                this.renderer.setColor(iconColor);
                this.renderer.drawSubImage(Textures.icons, this.posX + this.width / 2 - 4, this.posY + this.height / 2 - 4, 8, 8, this.iconX * 8, this.iconY * 8);
            }
            if (this.text != null) {
                int textWidth = this.fontRenderer.getStringWidth(this.text);
                int textX = this.posX + (this.width - textWidth) / 2;
                int textY = this.posY + this.height / 2 - 4;
                this.fontRenderer.drawString(this.text, textX, textY, 0xFFFFFF, true);
            }
            this.renderer.resetColor();
        }
    }

    protected static class FileComparator
    implements Comparator<File> {
        protected FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return Boolean.compare(o2.isDirectory(), o1.isDirectory());
        }
    }

    protected static class FileElement
    extends GuiListButton {
        public final GuiFileChooser fileChooser;
        public final File file;
        private final String name;

        public FileElement(GuiFileChooser screen, File file) {
            super(screen);
            this.fileChooser = screen;
            this.file = file;
            String name = file.getName();
            if (name == null || name.length() == 0) {
                name = file.getAbsolutePath();
            }
            this.name = name;
            this.setSize(100, 12);
        }

        @Override
        public void draw() {
            int iconY;
            int iconX;
            if (this.isFocused()) {
                this.renderer.setColor(0xFFFFFF);
                this.renderer.drawRectangleOutline(this.posX - 1, this.posY - 1, this.width + 2, this.height + 2);
                this.renderer.resetColor();
            }
            int x1 = this.posX + 2;
            if (this.file.isDirectory()) {
                iconX = 0;
                iconY = 8;
            } else {
                iconX = 8;
                iconY = 8;
            }
            this.renderer.drawSubImage(Textures.icons, x1, this.posY + this.height / 2 - 4, 8, 8, iconX, iconY);
            this.fontRenderer.drawString(this.name, x1 + 10, this.posY + this.height / 2 - 4, 0xFFFFFF, false);
        }

        @Override
        public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
            if (this.screen.isMouseOver(this) && pressed && this.isFocused() && this.click(false)) {
                return true;
            }
            return super.mouseEvent(button, pressed, mouseX, mouseY);
        }

        @Override
        public boolean keyEvent(int key, boolean pressed) {
            if (this.isFocused() && pressed && (key == 32 || key == 10) && this.click(true)) {
                return true;
            }
            return super.keyEvent(key, pressed);
        }

        public boolean click(boolean focus) {
            if (this.file.isDirectory()) {
                this.fileChooser.setDirectory(this.file, true, focus);
                return true;
            }
            return false;
        }
    }

    protected static class FileList
    extends GuiScrollableList {
        static GuiScrollableList.ListLayout layout = new GuiScrollableList.ListLayout();

        static {
            FileList.layout.innerPadding = 0;
            FileList.layout.outerPadding = 0;
            FileList.layout.align = GuiScrollableList.ListLayout.Align.LEFT;
        }

        public FileList(GuiScreen screen) {
            super(screen, layout);
            this.centerElements = false;
            this.useScissor = true;
            this.scissorBorder = 1;
            this.scrollToElementOffset = 0;
        }

        @Override
        public void draw() {
            this.renderer.setColor(0);
            this.renderer.drawRectangle(this.posX, this.posY, this.width, this.height);
            this.renderer.setColor(0x808080);
            this.renderer.drawRectangleOutline(this.posX - 1, this.posY - 1, this.width + 2, this.height + 2);
            this.renderer.resetColor();
            super.draw();
        }
    }
}

