/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen;

import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiContainer;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.util.ContainerListener;
import b100.installer.gui.modern.util.FocusDirection;
import b100.installer.gui.modern.util.FocusListener;
import b100.installer.gui.modern.util.Focusable;
import b100.installer.gui.modern.util.ListenerList;
import b100.installer.gui.modern.util.ScreenListener;

public abstract class GuiScreen
extends GuiContainer
implements FocusListener,
ContainerListener {
    private boolean initialized = false;
    public double mouseX = -1.0;
    public double mouseY = -1.0;
    public GuiScreen parentScreen;
    protected Focusable focusedElement;
    public final ListenerList<ScreenListener> screenListeners = new ListenerList(this);
    public final ListenerList<FocusListener> focusListeners = new ListenerList(this);

    public GuiScreen(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.containerListeners.add(this);
    }

    public final void init() {
        if (this.initialized) {
            this.initialized = false;
            this.removeAll();
            this.width = 0;
            this.height = 0;
        }
        this.onInit();
        this.setSize(this.renderer.getWidth(), this.renderer.getHeight());
        this.onResize();
        this.initialized = true;
    }

    protected abstract void onInit();

    @Override
    public void onResize() {
        super.onResize();
    }

    @Override
    public boolean keyEvent(int key, boolean pressed) {
        FocusDirection focusDirection;
        if (pressed && key == 27) {
            this.close();
            return true;
        }
        if (super.keyEvent(key, pressed)) {
            return true;
        }
        if (pressed && key == 8) {
            this.back();
            return true;
        }
        return pressed && (focusDirection = FocusDirection.get(key)) != null && this.focusNextElement(focusDirection);
    }

    public boolean focusNextElement(FocusDirection direction) {
        Focusable next = this.getNextScreenFocusableElement(this.focusedElement, direction);
        if (next != null) {
            next.setFocused(true);
            return true;
        }
        return false;
    }

    public Focusable getNextScreenFocusableElement(Focusable focusedElement, FocusDirection direction) {
        Focusable next;
        if (focusedElement != null) {
            next = Focusable.findNextFocusableElement((GuiElement)((Object)focusedElement), direction);
            if (next == null && direction.isTab()) {
                next = this.getFirstFocusableElement(direction);
            }
        } else {
            next = this.getFirstFocusableElement(direction);
        }
        return next;
    }

    @Override
    public void elementAdded(GuiContainer parent, GuiElement element) {
        if (element instanceof Focusable) {
            Focusable focusable = (Focusable)((Object)element);
            focusable.getFocusListeners().add(this);
        }
        if (element instanceof ScreenListener) {
            ScreenListener screenListener = (ScreenListener)((Object)element);
            this.screenListeners.add(screenListener);
        }
        if (element instanceof FocusListener) {
            FocusListener focusListener = (FocusListener)((Object)element);
            this.focusListeners.add(focusListener);
        }
        if (element instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)element;
            container.elements.forEach(e -> this.elementAdded(container, (GuiElement)e));
            container.containerListeners.add(this);
        }
    }

    @Override
    public void focusChanged(Focusable focusable) {
        if (focusable.isFocused()) {
            if (this.focusedElement != null && this.focusedElement != focusable) {
                this.focusedElement.setFocused(false);
            }
            this.focusedElement = focusable;
        }
        this.focusListeners.forEach(listener -> listener.focusChanged(focusable));
    }

    public Focusable getFocusedElement() {
        return this.focusedElement;
    }

    public GuiElement getMouseOver() {
        return this.getClickElementAt(this.mouseX, this.mouseY);
    }

    public boolean isMouseOver(GuiElement element) {
        return this.getClickElementAt(this.mouseX, this.mouseY) == element;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void back() {
        this.setScreen(this.parentScreen);
    }

    public void close() {
        this.setScreen(null);
    }

    public void setScreen(GuiScreen screen) {
        InstallerGuiModern.getInstance().setScreen(screen);
    }

    public void onScreenOpened() {
        this.screenListeners.forEach(listener -> listener.onScreenOpened(this));
    }
}

