/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen;

import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiScrollBar;
import b100.installer.gui.modern.element.GuiScrollableList;
import b100.installer.gui.modern.screen.GuiScreen;

public abstract class GuiScrollListScreen
extends GuiScreen {
    public GuiScrollableList scrollList;
    public GuiScrollBar scrollBar;
    public GuiScrollableList.Layout listLayout;
    public int headerSize = 32;
    public int footerSize = 32;
    public String title;
    private GuiBackground background;
    private GuiBackground header;
    private GuiBackground footer;

    public GuiScrollListScreen(GuiScreen parentScreen) {
        super(parentScreen);
    }

    public abstract void initScrollElements();

    @Override
    protected void onInit() {
        this.background = this.add(new GuiBackground(this, 0x202020));
        this.listLayout = this.getListLayout();
        this.scrollList = this.add(new GuiScrollableList(this, this.listLayout));
        this.initScrollElements();
        this.header = new GuiBackground(null);
        this.footer = new GuiBackground(null);
        this.add(this.header);
        this.add(this.footer);
        this.scrollList.createShadows(this);
        this.scrollBar = this.add(new GuiScrollBar(this, this.scrollList));
    }

    @Override
    public void draw() {
        this.background.offset = (int)(this.scrollList.getScrollAmount() / 2.0);
        super.draw();
        if (this.title != null) {
            this.fontRenderer.drawCenteredString(this.title, this.width / 2, this.headerSize / 2 - 4, -1, true);
        }
    }

    @Override
    public void onResize() {
        this.scrollList.setPosition(0, this.headerSize).setSize(this.width, this.height - (this.headerSize + this.footerSize));
        int contentWidth = this.listLayout.getContentWidth(this.scrollList);
        this.scrollBar.setPosition(this.scrollList.posX + this.scrollList.width / 2 + contentWidth / 2 + 16, this.scrollList.posY).setSize(this.scrollBar.width, this.scrollList.height);
        this.header.setPosition(0, 0).setSize(this.width, this.headerSize);
        this.footer.setPosition(0, this.height - this.footerSize).setSize(this.width, this.footerSize);
        super.onResize();
    }

    public void setDoubleFooterButtonPositions(GuiElement left, GuiElement right) {
        GuiScrollListScreen.setDoubleFooterButtonPositions(this, this.height - this.footerSize + 4, left, right);
    }

    public GuiScrollableList.Layout getListLayout() {
        return new GuiScrollableList.ListLayout();
    }

    public static void setDoubleFooterButtonPositions(GuiScreen screen, int y, GuiElement left, GuiElement right) {
        int p = 2;
        int w = 150;
        int center = screen.width / 2;
        int x0 = center - w - p;
        int x1 = center + p;
        left.setPosition(x0, y).setSize(w, 20);
        right.setPosition(x1, y).setSize(w, 20);
    }
}

