/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.screen.multimc;

import b100.installer.Versions;
import b100.installer.gui.modern.InstallerGuiModern;
import b100.installer.gui.modern.element.GuiBackground;
import b100.installer.gui.modern.element.GuiButton;
import b100.installer.gui.modern.element.GuiCheckbox;
import b100.installer.gui.modern.element.GuiDialog;
import b100.installer.gui.modern.element.GuiElement;
import b100.installer.gui.modern.element.GuiImageElement;
import b100.installer.gui.modern.element.GuiProgressBar;
import b100.installer.gui.modern.element.GuiTextElement;
import b100.installer.gui.modern.render.Textures;
import b100.installer.gui.modern.screen.GuiScreen;
import b100.installer.gui.modern.screen.GuiSelectVersion;
import b100.installer.gui.modern.screen.multimc.GuiSelectInstance;
import b100.installer.gui.modern.util.ActionListener;
import b100.installer.installer.MultiMCInstaller;
import b100.installer.installer.ProgressListener;
import b100.installer.util.MultiMCHelper;
import b100.json.JsonParser;
import b100.json.element.JsonArray;
import b100.json.element.JsonObject;
import java.awt.EventQueue;
import java.io.File;
import java.util.Objects;

public class GuiInstallMultiMC
extends GuiScreen
implements ActionListener,
ProgressListener {
    public File instancesFolder;
    public GuiButton buttonInstall;
    public GuiButton buttonSelectVersion;
    public GuiButton buttonSelectInstance;
    public GuiCheckbox checkboxAdvancedMode;
    public final Versions.Version latestStableVersion;
    public Versions.Version selectedVersion = null;
    public InstanceInfo selectedInstance = null;
    public MultiMCInstaller multiMcInstaller = new MultiMCInstaller();
    public boolean advancedMode = false;
    public boolean installing = false;
    public String installerStatus = null;
    public GuiTextElement line0;
    public GuiTextElement line1;
    public GuiImageElement logo;
    public GuiProgressBar progressBar;

    public GuiInstallMultiMC(GuiScreen parentScreen, File launcherFolder) {
        super(parentScreen);
        if (launcherFolder == null) {
            throw new NullPointerException("Launcher folder is null!");
        }
        this.instancesFolder = MultiMCHelper.getInstancesDirectory();
        if (this.instancesFolder == null) {
            throw new NullPointerException("Instances folder is null!");
        }
        this.latestStableVersion = Versions.getInstance().getLatestStableVersion();
        System.out.println("Latest Stable Version: " + this.latestStableVersion);
        this.selectedVersion = this.latestStableVersion;
        this.setInstance("BTA_MANAGED_INSTANCE");
    }

    @Override
    protected void onInit() {
        this.add(new GuiBackground(this));
        this.logo = this.add(new GuiImageElement(Textures.logo));
        this.add(new GuiTextElement().setText("Install into MultiMC / Prism Launcher").setTextColor(0x505050).setPosition(2, 2));
        this.buttonInstall = this.add(new GuiButton(this, "Install").addActionListener(this));
        if (this.advancedMode) {
            this.buttonSelectVersion = this.add(new GuiButton(this, "Version").addActionListener(this));
            this.buttonSelectInstance = this.add(new GuiButton(this, "Instance").addActionListener(this));
        } else {
            this.setInstance("BTA_MANAGED_INSTANCE");
            this.selectedVersion = this.latestStableVersion;
        }
        this.checkboxAdvancedMode = this.add(new GuiCheckbox(this, "Advanced Mode", this.advancedMode).addActionListener(this));
        this.line0 = this.add(new GuiTextElement().setAlign(0.5, 0.0));
        this.line1 = this.add(new GuiTextElement().setAlign(0.5, 0.0));
        this.progressBar = this.add(new GuiProgressBar().setEnabled(false).setProgress(0.5f));
        this.refresh();
    }

    @Override
    public void draw() {
        this.updateStrings();
        super.draw();
    }

    public void updateStrings() {
        this.line0.setText(null).setTextColor(0xFFFFFF);
        this.line1.setText(null).setTextColor(0xFFFFFF);
        if (this.installing) {
            this.line1.setText(this.installerStatus);
            return;
        }
        if (!this.selectedInstance.instanceExists) {
            this.line1.setText("Not installed!");
            return;
        }
        if (this.advancedMode) {
            this.line1.setText("Installed Version: " + Versions.Version.getDisplayName(this.selectedInstance.currentVersion));
            return;
        }
        this.line0.setText("Installed Version: " + Versions.Version.getDisplayName(this.selectedInstance.currentVersion));
        if (Objects.equals(this.selectedInstance.currentVersion, this.latestStableVersion)) {
            this.line1.setText("Up to date!").setTextColor(65280);
        } else {
            this.line1.setText("Update Available: " + this.latestStableVersion.getDisplayName()).setTextColor(65280);
        }
    }

    @Override
    public void onResize() {
        super.onResize();
        int center = this.posX + this.width / 2;
        int x1 = this.width / 2 - 100;
        int y1 = this.height / 4 + 24;
        int p = 24;
        if (this.advancedMode) {
            this.buttonInstall.setPosition(x1, y1 + p * 2);
            this.buttonSelectVersion.setPosition(x1, y1 + p * 3);
            this.buttonSelectInstance.setPosition(x1, y1 + p * 4);
        } else {
            this.buttonInstall.setPosition(x1, y1 + p * 3);
        }
        int y2 = this.buttonInstall.posY - 24;
        if (this.advancedMode) {
            y2 += 6;
        }
        this.line0.setPosition(center, y2 - 12).setSize(0, 0);
        this.line1.setPosition(center, y2 + 0).setSize(0, 0);
        this.progressBar.setPosition(center - this.progressBar.width / 2, this.line1.posY + 12);
        this.checkboxAdvancedMode.setPosition(8, this.height - this.checkboxAdvancedMode.height - 8);
        this.logo.setPosition((this.width - this.logo.width) / 2, 38);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        if (source == this.buttonInstall) {
            this.install();
        }
        if (source == this.buttonSelectVersion) {
            this.setScreen(new GuiSelectVersion(this, this.multiMcInstaller, version -> {
                this.selectedVersion = version;
                this.refresh();
                this.setScreen(this);
            }, this.selectedVersion));
        }
        if (source == this.buttonSelectInstance) {
            this.setScreen(new GuiSelectInstance(this, this.instancesFolder, instance -> {
                this.setInstance((String)instance);
                this.refresh();
                this.setScreen(this);
            }, this.selectedInstance.getInstanceFolderName()));
        }
        if (source == this.checkboxAdvancedMode) {
            this.advancedMode = this.checkboxAdvancedMode.isChecked();
            boolean wasFocused = this.checkboxAdvancedMode.isFocused();
            this.init();
            if (wasFocused) {
                this.checkboxAdvancedMode.setFocused(true);
            }
        }
    }

    public void install() {
        this.buttonInstall.setClickable(false);
        File launcherDirectory = MultiMCHelper.getLauncherDirectory();
        File instanceFolder = new File(this.instancesFolder, this.selectedInstance.getInstanceFolderName());
        MultiMCInstaller.Parameters params = new MultiMCInstaller.Parameters(launcherDirectory, instanceFolder, this.selectedVersion);
        Runnable runnable = () -> {
            try {
                this.installing = true;
                this.update("Installing...");
                this.multiMcInstaller.install(params, (ProgressListener)this);
                this.installing = false;
                this.update("Done!");
                EventQueue.invokeLater(() -> {
                    this.buttonInstall.setClickable(true);
                    GuiDialog doneDialog = new GuiDialog(this);
                    doneDialog.add(new GuiTextElement("Done!", 0.5, 0.0));
                    GuiButton button = new GuiButton(this, "Close");
                    button.addActionListener(e -> doneDialog.close());
                    button.width = 150;
                    doneDialog.add(button);
                    this.add(doneDialog);
                    this.refresh();
                });
            }
            catch (Exception e) {
                InstallerGuiModern.getInstance().onCrash(e);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("Install-Thread");
        thread.start();
    }

    @Override
    public void update(String string) {
        this.installerStatus = string;
        InstallerGuiModern.getInstance().scheduleRepaint();
        this.progressBar.setEnabled(false);
    }

    @Override
    public void setProgress(float progress) {
        this.progressBar.setEnabled(true);
        this.progressBar.setProgress(progress);
        InstallerGuiModern.getInstance().scheduleRepaint();
    }

    public void setInstance(String instanceName) {
        File instanceFolder = new File(this.instancesFolder, instanceName);
        if (this.selectedInstance == null || !this.selectedInstance.instanceFolder.equals(instanceFolder)) {
            System.out.println("Set Instance: " + instanceName);
            this.selectedInstance = new InstanceInfo(instanceFolder);
        }
    }

    public void refresh() {
        if (this.selectedInstance != null) {
            this.selectedInstance = new InstanceInfo(this.selectedInstance.instanceFolder);
        }
        if (this.advancedMode) {
            this.buttonSelectVersion.text = "Version: " + this.selectedVersion.getDisplayName();
            this.buttonSelectInstance.text = "Instance: " + this.selectedInstance.getName();
            this.buttonInstall.text = Objects.equals(this.selectedInstance.currentVersion, this.selectedVersion) ? "Reinstall" : "Install";
        } else {
            this.buttonInstall.text = Objects.equals(this.selectedInstance.currentVersion, this.selectedVersion) ? "Reinstall" : (this.selectedInstance.instanceExists ? "Update" : "Install");
        }
    }

    public static class InstanceInfo {
        public final File instanceFolder;
        public final boolean instanceExists;
        public final Versions.Version currentVersion;
        public final File oldBtaJarFile;
        public final String displayName;

        public InstanceInfo(File instanceFolder) {
            if (instanceFolder == null) {
                throw new NullPointerException("Instance folder is null!");
            }
            this.instanceFolder = instanceFolder;
            this.instanceExists = MultiMCHelper.isInstance(instanceFolder);
            if (!MultiMCHelper.isInstance(instanceFolder)) {
                this.displayName = null;
                this.oldBtaJarFile = null;
                this.currentVersion = null;
                return;
            }
            this.displayName = MultiMCHelper.getInstanceName(instanceFolder);
            File mmcPackFile = new File(instanceFolder, "mmc-pack.json");
            File patchesFolder = new File(instanceFolder, "patches");
            File jarmodsFolder = new File(instanceFolder, "jarmods");
            String existingBtaPatchName = null;
            JsonObject mmcPack = (JsonObject)JsonParser.instance.parseFileContent(mmcPackFile);
            JsonArray components = mmcPack.getArray("components");
            int i = 0;
            while (i < components.length()) {
                JsonObject obj = components.get(i).getAsObject();
                String uid = obj.getString("uid");
                if (uid.equals("org.multimc.jarmod.bta")) {
                    existingBtaPatchName = "org.multimc.jarmod.bta";
                }
                if (uid.equals("custom.jarmod.bta")) {
                    existingBtaPatchName = "custom.jarmod.bta";
                }
                ++i;
            }
            if (existingBtaPatchName != null) {
                File btaPatchFile = new File(patchesFolder, String.valueOf(existingBtaPatchName) + ".json");
                JsonObject btaPatch = (JsonObject)JsonParser.instance.parseFileContent(btaPatchFile);
                String versionName = btaPatch.getString("version");
                this.currentVersion = Versions.getInstance().get(versionName);
                JsonArray jarMods = btaPatch.getArray("jarMods");
                JsonObject btaJarMod = jarMods.get(0).getAsObject();
                String filename = btaJarMod.getString("MMC-filename");
                this.oldBtaJarFile = new File(jarmodsFolder, filename);
            } else {
                System.out.println("Could not find BTA in instance!");
                this.currentVersion = null;
                this.oldBtaJarFile = null;
            }
        }

        public String getName() {
            if (this.displayName == null) {
                return this.instanceFolder.getName();
            }
            return this.displayName;
        }

        public String getInstanceFolderName() {
            return this.instanceFolder.getName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

