/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.gui.modern.util;

import b100.installer.gui.modern.element.GuiElement;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;

public final class ListenerList<ListenerType> {
    private GuiElement parentElement;
    private ArrayList<ListenerType> listeners = new ArrayList();
    private ArrayList<ListenerType> previousListeners = new ArrayList();
    private boolean iterating = false;

    public ListenerList(GuiElement parentElement) {
        this.parentElement = parentElement;
    }

    public GuiElement add(ListenerType e) {
        if (this.iterating) {
            throw new ConcurrentModificationException("Modified list " + this + " while iterating!");
        }
        if (this.listeners.contains(e)) {
            this.listeners.remove(e);
        }
        this.listeners.add(e);
        return this.parentElement;
    }

    public boolean remove(ListenerType e) {
        if (this.iterating) {
            throw new ConcurrentModificationException("Modified list " + this + " while iterating!");
        }
        return this.listeners.remove(e);
    }

    public void forEach(Consumer<ListenerType> action) {
        if (this.listeners.size() == 0) {
            return;
        }
        if (this.iterating) {
            throw new RuntimeException("Already iterating " + this);
        }
        this.iterating = true;
        this.previousListeners.addAll(this.listeners);
        for (ListenerType listener : this.previousListeners) {
            action.accept(listener);
        }
        this.previousListeners.clear();
        this.iterating = false;
    }
}

