/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.installer;

import b100.installer.Config;
import b100.installer.DownloadHelper;
import b100.installer.Versions;
import b100.installer.config.ConfigUtil;
import b100.installer.installer.Installer;
import b100.installer.installer.ProgressListener;
import b100.installer.util.ModLoader;
import b100.installer.util.Utils;
import b100.json.element.JsonObject;
import b100.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class BetacraftInstaller
implements Installer {
    @Override
    public boolean install(Map<String, Object> parameters, ProgressListener progressListener) {
        String selectedVersion = (String)parameters.get("version");
        ModLoader loader = (ModLoader)((Object)parameters.get("loader"));
        File betacraftDirectory = new File((String)parameters.get("betacraftdir"));
        System.out.println("Selected Version: " + selectedVersion);
        System.out.println("Selected Mod Loader: " + (Object)((Object)loader));
        System.out.println("BetaCraft Directory: " + betacraftDirectory.getAbsolutePath());
        Config config = Config.getInstance();
        config.lastSelectedVersion.value = selectedVersion;
        config.lastInstallType.value = "betacraft";
        config.lastBetaCraftDirectory.value = betacraftDirectory.getAbsolutePath();
        config.save();
        if (!betacraftDirectory.exists() || !betacraftDirectory.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Invalid BetaCraft Directory: '" + betacraftDirectory.getAbsolutePath() + "'!");
            config.lastBetaCraftDirectory = null;
            config.save();
            return false;
        }
        Versions.Version version = Versions.getInstance().get(selectedVersion);
        JsonObject manifest = version.manifest;
        JsonObject betaCraftObject = manifest.getObject("betacraft");
        if (betaCraftObject == null) {
            JOptionPane.showMessageDialog(null, "Version '" + selectedVersion + "' is not compatible with BetaCraft!");
            return false;
        }
        File versionsFolder = new File(betacraftDirectory, "versions");
        String versionName = "BTA " + selectedVersion;
        File outputJar = new File(versionsFolder, String.valueOf(versionName) + ".jar");
        if (!outputJar.exists()) {
            System.out.println("Installing version");
            File minecraftJar = new File(versionsFolder, "b1.7.3.jar");
            if (!minecraftJar.exists()) {
                JOptionPane.showMessageDialog(null, "Please start Beta 1.7.3 once before installing!");
                return false;
            }
            File btaJarFile = version.getFile("client.jar", progressListener);
            Utils.createModdedMinecraftJar(minecraftJar, btaJarFile, outputJar);
        } else {
            System.out.println("Version is installed");
        }
        String launchMethod = betaCraftObject.getString("launch-method");
        if (launchMethod.equals("default")) {
            System.out.println("Using default launch method");
        } else {
            File installedLaunchMethod = new File(betacraftDirectory, "launcher/launch-methods/" + launchMethod + ".jar");
            if (!installedLaunchMethod.exists()) {
                System.out.println("Installing launch method");
                File cachedFile = DownloadHelper.getFile("misc/betacraft/" + launchMethod + ".jar", progressListener);
                Utils.copyFile(cachedFile, installedLaunchMethod, progressListener);
            } else {
                System.out.println("Launch method is installed");
            }
            File versionInfoFile = new File(versionsFolder, "jsons/" + versionName + ".info");
            if (!versionInfoFile.exists()) {
                System.out.println("Creating version info file");
                String string = "launch-method:" + launchMethod;
                StringUtils.saveStringToFile(versionInfoFile, string);
            } else {
                System.out.println("Version info file exists!");
            }
        }
        String instanceName = (String)parameters.get("instancename");
        File instanceFile = new File(betacraftDirectory, "/launcher/instances/" + instanceName + ".txt");
        boolean useProxy = betaCraftObject.getBoolean("proxy");
        Map<String, String> properties = instanceFile.exists() ? Utils.loadProperties(instanceFile) : new HashMap<String, String>();
        if (!properties.containsKey("width")) {
            properties.put("width", "854");
        }
        if (!properties.containsKey("height")) {
            properties.put("height", "480");
        }
        if (!properties.containsKey("addons")) {
            properties.put("addons", "");
        }
        if (!properties.containsKey("gameDir")) {
            properties.put("gameDir", new File(betacraftDirectory, instanceName).getAbsolutePath());
        }
        properties.put("proxy", String.valueOf(useProxy));
        properties.put("version", versionName);
        ConfigUtil.saveProperties(instanceFile, properties, ':');
        JOptionPane.showMessageDialog(null, "Done!");
        return true;
    }

    @Override
    public boolean isCompatible(String version, ModLoader loader) {
        return false;
    }
}

