/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.updater;

import b100.installer.Download;
import b100.installer.Global;
import b100.installer.gui.classic.GridPanel;
import b100.installer.util.Utils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class UpdateInfoWindow
implements ActionListener {
    public JFrame frame;
    public GridPanel panel;
    public JTextArea textArea;
    public JButton updateButton;
    public JButton dontUpdateButton;
    public Runnable updateAction;
    public Runnable dontUpdateAction;

    public UpdateInfoWindow(List<String> availableVersions, Runnable updateAction, Runnable dontUpdateAction) {
        this.updateAction = updateAction;
        this.dontUpdateAction = dontUpdateAction;
        this.frame = new JFrame();
        this.frame.setTitle("Better than Adventure! Installer");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setText("Loading changelog...");
        this.textArea.setFont(new Font("Monospaced", 1, 12));
        JScrollPane scrollPane = new JScrollPane(this.textArea, 22, 30);
        scrollPane.setPreferredSize(new Dimension(400, 240));
        JPanel buttonPanel = new JPanel();
        Dimension buttonSize = new Dimension(128, 24);
        this.dontUpdateButton = new JButton("Don't Update");
        this.dontUpdateButton.addActionListener(this);
        this.dontUpdateButton.setPreferredSize(buttonSize);
        buttonPanel.add(this.dontUpdateButton);
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(this);
        this.updateButton.setPreferredSize(buttonSize);
        buttonPanel.add(this.updateButton);
        this.panel = new GridPanel();
        GridBagConstraints c = this.panel.getGridBagConstraints();
        int padding = 4;
        c.insets = new Insets(padding, padding, padding, padding);
        JLabel label1 = new JLabel("Update Available!");
        label1.setPreferredSize(new Dimension(24, 24));
        label1.setHorizontalAlignment(0);
        this.panel.add(label1, 0, 0, 1.0, 0.0);
        c.insets.top = 0;
        this.panel.add(scrollPane, 0, 1, 1.0, 1.0);
        this.panel.add(buttonPanel, 0, 2, 1.0, 0.0);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setMinimumSize(this.frame.getSize());
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setVisible(true);
        Utils.createAndRunThread("Get-Changelog", true, new DownloadChangelogThread(availableVersions));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateButton) {
            Utils.createAndRunThread("Update-Installer", false, this.updateAction);
            this.frame.dispose();
        }
        if (e.getSource() == this.dontUpdateButton) {
            Utils.createAndRunThread("Run-Installer", false, this.dontUpdateAction);
            this.frame.dispose();
        }
    }

    class DownloadChangelogThread
    implements Runnable {
        List<String> versions;

        public DownloadChangelogThread(List<String> versions) {
            this.versions = versions;
        }

        @Override
        public void run() {
            StringBuilder str = new StringBuilder();
            str.append("Changelog:\n\n");
            int i = 0;
            while (i < this.versions.size()) {
                block5: {
                    String[] lines;
                    String changelog;
                    String version = this.versions.get(i);
                    str.append(version).append(":\n");
                    String url = String.valueOf(Global.getDownloadUrl()) + "bta-installer/changelogs/" + version + ".txt";
                    try {
                        changelog = new Download(url).downloadAsString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        str.append(" - Could not load changelog!\n\n");
                        break block5;
                    }
                    String[] stringArray = lines = changelog.split("\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if ((line = line.trim()).length() != 0) {
                            str.append(" - ").append(line).append('\n');
                        }
                        ++n2;
                    }
                    str.append('\n');
                }
                ++i;
            }
            SwingUtilities.invokeLater(() -> {
                UpdateInfoWindow.this.textArea.setText(str.toString());
                UpdateInfoWindow.this.textArea.setCaretPosition(0);
            });
        }
    }
}

