/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CrashHandler {
    public CrashHandler(String message) {
        this(message, null);
    }

    public CrashHandler(String message, Component parent) {
        JFrame frame = new JFrame();
        frame.setTitle("Crash Handler");
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setText(message);
        JScrollPane scrollPane = new JScrollPane(textArea, 22, 32);
        scrollPane.setPreferredSize(new Dimension(640, 320));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int padding = 4;
        c.insets = new Insets(padding, padding, padding, padding);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)scrollPane, c);
        frame.add(panel);
        frame.pack();
        frame.setMinimumSize(new Dimension(frame.getWidth(), frame.getHeight()));
        frame.setLocationRelativeTo(parent);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public static void createErrorLog(StringBuilder str, Throwable throwable) {
        str.append(throwable.getClass().getName());
        String message = throwable.getMessage();
        if (message != null) {
            str.append(": ").append(message);
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement element = stackTrace[i];
            str.append('\n').append("    at ").append(element);
            ++i;
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            str.append("\nCaused by: ");
            CrashHandler.createErrorLog(str, cause);
        }
    }
}

