/*
 * Decompiled with CFR 0.152.
 */
package b100.installer.util;

import b100.installer.Download;
import b100.installer.Global;
import b100.installer.config.ConfigUtil;
import b100.installer.util.Utils;
import b100.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.imageio.ImageIO;

public class MultiMCHelper {
    private static File assetsDirectory;
    private static File launcherDirectory;
    private static File runInstanceDirectory;
    private static File instancesDirectory;
    private static File iconsDirectory;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public static void init(String[] args) {
        File file;
        if (initialized) {
            return;
        }
        initialized = true;
        if (args != null) {
            MultiMCHelper.processArgs(args);
        }
        if (runInstanceDirectory == null) {
            MultiMCHelper.tryGetInstanceDirectoryFromRunDirectory();
        }
        if (launcherDirectory == null && assetsDirectory != null) {
            System.out.println("No launcher directory provided, using directory above assets");
            launcherDirectory = assetsDirectory.getParentFile();
        }
        if (launcherDirectory == null && runInstanceDirectory != null && (file = MultiMCHelper.getLauncherDirectoryFromInstanceDirectory(runInstanceDirectory)) != null) {
            launcherDirectory = file;
        }
        if (launcherDirectory != null) {
            System.out.println("Launcher Directory: " + launcherDirectory);
        } else {
            System.out.println("Could not automatically determine a launcher directory!");
        }
        MultiMCHelper.setIconsAndInstanceDirectories(launcherDirectory);
        MultiMCHelper.updateInstallerInstanceIcon();
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("--assetsDir")) {
                Utils.getDirFromArgs("Assets Directory", args, ++i, file -> {
                    File file2 = assetsDirectory = file;
                });
            }
            if (arg.equals("--launcherDir")) {
                Utils.getDirFromArgs("Launcher Directory", args, ++i, file -> {
                    File file2 = launcherDirectory = file;
                });
            }
            if (arg.equals("--instanceDir")) {
                Utils.getDirFromArgs("Instance Directory", args, ++i, file -> {
                    File file2 = runInstanceDirectory = file;
                });
            }
            ++i;
        }
    }

    private static void tryGetInstanceDirectoryFromRunDirectory() {
        File runDirectory = new File("").getAbsoluteFile();
        System.out.println("Run Directory: " + runDirectory);
        File maybeInstanceDirectory = runDirectory.getParentFile();
        if (MultiMCHelper.isInstance(maybeInstanceDirectory)) {
            System.out.println("Found instance in run directory: " + maybeInstanceDirectory.getAbsolutePath());
            runInstanceDirectory = maybeInstanceDirectory;
        } else if (maybeInstanceDirectory != null) {
            System.out.println("Not an instance: " + maybeInstanceDirectory.getAbsolutePath());
        }
    }

    private static void setIconsAndInstanceDirectories(File launcherDirectory) {
        instancesDirectory = null;
        iconsDirectory = null;
        if (launcherDirectory != null) {
            File configFile = MultiMCHelper.getConfigFile(launcherDirectory);
            if (configFile != null) {
                Map<String, String> config = ConfigUtil.loadPropertiesFile(configFile, '=');
                String instanceDirName = config.get("InstanceDir");
                if (instanceDirName != null) {
                    File file = new File(launcherDirectory, instanceDirName);
                    if (file.isDirectory()) {
                        instancesDirectory = file;
                    } else {
                        System.out.println("Not a directory: " + file.getAbsolutePath());
                    }
                } else {
                    System.out.println("No instance directory in config file!");
                }
                String iconsDirName = config.get("IconsDir");
                if (iconsDirName != null) {
                    File file = new File(launcherDirectory, iconsDirName);
                    if (file.isDirectory()) {
                        iconsDirectory = file;
                    } else {
                        System.out.println("Not a directory: " + file.getAbsolutePath());
                    }
                } else {
                    System.out.println("No icons directory in config file!");
                }
            } else {
                System.out.println("No config file in launcher folder: " + launcherDirectory.getAbsolutePath());
            }
        }
        if (instancesDirectory == null) {
            File file = runInstanceDirectory;
            while (file != null) {
                if (MultiMCHelper.isInstancesFolder(file)) {
                    instancesDirectory = file;
                    break;
                }
                file = file.getParentFile();
            }
        }
    }

    private static void updateInstallerInstanceIcon() {
        if (runInstanceDirectory == null) {
            return;
        }
        File instanceCfg = new File(runInstanceDirectory, "instance.cfg");
        if (!instanceCfg.exists() || instanceCfg.exists()) {
            return;
        }
        File instanceCfgCopy = new File(runInstanceDirectory, "instance.cfg.bak");
        Utils.copyFile(instanceCfg, instanceCfgCopy, null);
        StringBuilder str = new StringBuilder();
        InputStream in = null;
        BufferedReader br = null;
        try {
            try {
                String line;
                in = new FileInputStream(instanceCfg);
                br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    String iconKey;
                    String key;
                    int i = line.indexOf(61);
                    if (i != -1 && (key = line.substring(0, i)).equals("iconKey") && (iconKey = line.substring(i + 1)) != null && iconKey.equalsIgnoreCase("default")) {
                        System.out.println("Instance is using default icon, let's change that!");
                        String iconName = "bta64";
                        MultiMCHelper.setIcon(iconName, new Download(String.valueOf(Global.getDownloadUrl()) + "bta-installer/icons/" + iconName + ".png").getAsImage());
                        line = "iconKey=" + iconName;
                    }
                    str.append(line).append('\n');
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        StringUtils.saveStringToFile(instanceCfg, str.toString());
    }

    private static File getLauncherDirectoryFromInstanceDirectory(File directory) {
        directory = directory.getAbsoluteFile();
        while (directory != null) {
            if (MultiMCHelper.isLauncherDirectory(directory)) {
                return directory;
            }
            directory = directory.getParentFile();
        }
        return null;
    }

    public static String getInstanceName(File instanceFolder) {
        return ConfigUtil.loadPropertiesFile(new File(instanceFolder, "instance.cfg"), '=').get("name");
    }

    private static File getConfigFile(File launcherFolder) {
        String[] launcherNames;
        String[] stringArray = launcherNames = new String[]{"multimc", "prismlauncher"};
        int n = launcherNames.length;
        int n2 = 0;
        while (n2 < n) {
            String launcherName = stringArray[n2];
            File file = new File(launcherFolder, String.valueOf(launcherName) + ".cfg");
            System.out.println("Check config file: " + file.getAbsolutePath());
            if (file.isFile()) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static void setLauncherDirectory(File file) {
        launcherDirectory = file;
        MultiMCHelper.setIconsAndInstanceDirectories(launcherDirectory);
    }

    public static boolean setIcon(String name, BufferedImage image) {
        if (name == null) {
            throw new NullPointerException("Name is null!");
        }
        if (image == null) {
            throw new NullPointerException("Icon is null!");
        }
        if (iconsDirectory != null) {
            File iconFile = new File(iconsDirectory, String.valueOf(name) + ".png");
            try {
                ImageIO.write((RenderedImage)image, "png", iconFile);
                return true;
            }
            catch (Exception e) {
                System.err.println("Could not write icon: " + iconFile.getAbsolutePath());
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isInstance(File file) {
        if (file.isDirectory()) {
            File instanceCfg = new File(file, "instance.cfg");
            File mmcPack = new File(file, "mmc-pack.json");
            return instanceCfg.isFile() && mmcPack.isFile();
        }
        return false;
    }

    public static boolean isLauncherDirectory(File file) {
        if (file != null && file.isDirectory()) {
            if (new File(file, "multimc.cfg").isFile()) {
                return true;
            }
            if (new File(file, "multimc.exe").isFile()) {
                return true;
            }
            if (new File(file, "prismlauncher.cfg").isFile()) {
                return true;
            }
            if (new File(file, "prismlauncher.exe").isFile()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInstancesFolder(File file) {
        return new File(file, "instgroups.json").isFile();
    }

    public static File getLauncherDirectory() {
        return launcherDirectory;
    }

    public static File getInstancesDirectory() {
        return instancesDirectory;
    }

    public static File getIconsDirectory() {
        return iconsDirectory;
    }

    public static File getRunInstanceDirectory() {
        return runInstanceDirectory;
    }
}

