/*
 * Decompiled with CFR 0.152.
 */
package b100.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public abstract class Utils {
    public static <E> List<E> toList(E[] array) {
        ArrayList<E> list = new ArrayList<E>();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static <E> E[] toArray(Class<E> clazz, List<E> list) {
        E[] array = Utils.createArray(clazz, list.size());
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static <E> E[] createArray(Class<E> clazz, int length) {
        try {
            return (Object[])Array.newInstance(clazz, length);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating Array of class " + clazz + " and length " + length);
        }
    }

    public static <E> E[] combineArray(Class<E> clazz, E[] array1, E[] array2) {
        E[] newArray = Utils.createArray(clazz, array1.length + array2.length);
        int i = 0;
        while (i < array1.length) {
            newArray[i] = array1[i];
            ++i;
        }
        i = 0;
        while (i < array2.length) {
            newArray[array1.length + i] = array2[i];
            ++i;
        }
        return newArray;
    }

    public static <E> E requireNonNull(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return e;
    }

    public static byte[] arraycopyShortToByte(short[] shortArray, byte[] byteArray) {
        return Utils.arraycopyShortToByte(shortArray, 0, byteArray, 0, shortArray.length << 1);
    }

    public static byte[] arraycopyShortToByte(short[] shortArray, int shortArrayOffset, byte[] byteArray, int byteArrayOffset, int byteCount) {
        int shortArrayLength = byteCount >> 1;
        int i = 0;
        while (i < shortArrayLength) {
            int j = (i << 1) + byteArrayOffset;
            int shortVal = shortArray[i + shortArrayOffset] & 0xFFFF;
            byteArray[j + 0] = (byte)(shortVal >> 8);
            byteArray[j + 1] = (byte)(shortVal >> 0);
            ++i;
        }
        return byteArray;
    }

    public static short[] arraycopyByteToShort(byte[] byteArray, short[] shortArray) {
        return Utils.arraycopyByteToShort(byteArray, 0, shortArray, 0, byteArray.length);
    }

    public static short[] arraycopyByteToShort(byte[] byteArray, int byteArrayOffset, short[] shortArray, int shortArrayOffset, int byteCount) {
        int shortArrayLength = byteCount >> 1;
        int i = 0;
        while (i < shortArrayLength) {
            int j = (i << 1) + byteArrayOffset;
            int byte0 = byteArray[j + 0] & 0xFF;
            int byte1 = byteArray[j + 1] & 0xFF;
            shortArray[i + shortArrayOffset] = (short)(byte0 << 8 | byte1);
            ++i;
        }
        return shortArray;
    }
}

