/*
 * Decompiled with CFR 0.152.
 */
package b100.xml;

import b100.utils.ObjectParser;
import b100.utils.Parser;
import b100.utils.ParserCollection;
import b100.utils.StringParser;
import b100.utils.StringReader;
import b100.utils.StringUtils;
import b100.xml.XmlFile;
import java.io.File;
import java.io.InputStream;

public class XmlParser
implements StringParser<XmlFile> {
    public static final XmlParser instance = new XmlParser();
    private final ParserCollection<XmlFile> parsers = new ParserCollection();
    private final Parser<XmlFile, String> stringParser = string -> XmlFile.read(new StringReader((String)string));
    private final Parser<XmlFile, File> fileParser = file -> this.stringParser.parse(StringUtils.getFileContentAsString(file));
    private final Parser<XmlFile, InputStream> streamParser = stream -> this.stringParser.parse(StringUtils.readInputString(stream));

    public XmlParser() {
        this.parsers.add(new ObjectParser<XmlFile, String>(String.class, this.stringParser));
        this.parsers.add(new ObjectParser<XmlFile, File>(File.class, this.fileParser));
        this.parsers.add(new ObjectParser<XmlFile, InputStream>(InputStream.class, this.streamParser));
    }

    public XmlFile parse(Object object) {
        return this.parsers.parse(object);
    }

    public ParserCollection<XmlFile> getParsers() {
        return this.parsers;
    }

    @Override
    public XmlFile parseString(String string) {
        return this.stringParser.parse(string);
    }
}

