/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityOtherPlayerMP
extends EntityPlayer {
    private int field_785_bg;
    private double field_784_bh;
    private double field_783_bi;
    private double field_782_bj;
    private double field_780_bk;
    private double field_786_bl;
    float field_20924_a = 0.0f;

    public EntityOtherPlayerMP(World world, String s) {
        super(world);
        this.username = s;
        this.heightOffset = 0.0f;
        this.footSize = 0.0f;
        this.noPhysics = true;
        this.field_22062_y = 0.25f;
        this.viewScale = 10.0;
        new GetSkinUrlThread(this);
    }

    @Override
    protected void resetHeight() {
        this.heightOffset = 0.0f;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return true;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.field_784_bh = x;
        this.field_783_bi = y;
        this.field_782_bj = z;
        this.field_780_bk = yRot;
        this.field_786_bl = xRot;
        this.field_785_bg = i;
    }

    @Override
    public void tick() {
        this.field_22062_y = 0.0f;
        super.tick();
        this.prevLimbYaw = this.limbYaw;
        double d = this.x - this.xo;
        double d1 = this.z - this.zo;
        float f = MathHelper.sqrt_double(d * d + d1 * d1) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.limbYaw += (f - this.limbYaw) * 0.4f;
        this.limbSwing += this.limbYaw;
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    @Override
    public void onDeath(Entity entity) {
    }

    @Override
    public void onLivingUpdate() {
        super.updatePlayerActionState();
        if (this.field_785_bg > 0) {
            double d3;
            double d = this.x + (this.field_784_bh - this.x) / (double)this.field_785_bg;
            double d1 = this.y + (this.field_783_bi - this.y) / (double)this.field_785_bg;
            double d2 = this.z + (this.field_782_bj - this.z) / (double)this.field_785_bg;
            for (d3 = this.field_780_bk - (double)this.yRot; d3 < -180.0; d3 += 360.0) {
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + d3 / (double)this.field_785_bg);
            this.xRot = (float)((double)this.xRot + (this.field_786_bl - (double)this.xRot) / (double)this.field_785_bg);
            --this.field_785_bg;
            this.setPos(d, d1, d2);
            this.setRot(this.yRot, this.xRot);
        }
        this.field_775_e = this.field_774_f;
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        float f1 = (float)Math.atan(-this.yd * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (f - this.field_774_f) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
    }

    @Override
    public void setEquippedSlot(int i, int j, int k, CompoundTag tag) {
        ItemStack itemstack = null;
        if (j >= 0) {
            itemstack = new ItemStack(j, 1, k, tag);
        }
        if (i == 0) {
            this.inventory.mainInventory[this.inventory.currentItem] = itemstack;
        } else {
            this.inventory.armorInventory[i - 1] = itemstack;
        }
    }

    @Override
    public void func_6420_o() {
    }
}

