/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.core.util.helper.Listener;
import org.lwjgl.opengl.GL11;

public class GuiButton
extends Gui
implements GuiElement {
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    public Listener<GuiButton> listener;

    public GuiButton(int id, int xPosition, int yPosition, String text) {
        this(id, xPosition, yPosition, 200, 20, text);
    }

    public GuiButton(int id, int xPosition, int yPosition, int width, int height, String text) {
        this.id = id;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayString = text;
    }

    protected int getButtonState(boolean hovered) {
        int state = 1;
        if (!this.enabled) {
            state = 0;
        } else if (hovered) {
            state = 2;
        }
        return state;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.fontRenderer;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46 + state * 20, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46 + state * 20, this.width / 2, this.height);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public GuiButton setListener(Listener<GuiButton> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.xPosition;
    }

    @Override
    public int getY() {
        return this.yPosition;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

