/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.mobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.client.gui.guidebook.mobs.MobPage;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.collection.Pair;

public class MobSection
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private final List<GuidebookSection.Index> indices = new ArrayList<GuidebookSection.Index>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public MobSection() {
        super("guidebook.section.mob", new ItemStack(Item.bone), 6723115, 12753692);
        for (Class<? extends Entity> e : MobInfoRegistry.getMobClassList()) {
            MobInfoRegistry.MobInfo mobInfo = MobInfoRegistry.getMobInfo(e);
            MobPage page = new MobPage(this, e, mobInfo);
            this.pages.add(page);
            this.indices.add(new Index(mobInfo, (GuidebookPage)page));
        }
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return this.indices;
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        ArrayList<GuidebookPage> filtered = new ArrayList<GuidebookPage>();
        if (this.filteredPages == null || !Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            for (Class<? extends Entity> e : MobInfoRegistry.getMobClassList()) {
                MobInfoRegistry.MobInfo mobInfo = MobInfoRegistry.getMobInfo(e);
                if (query.strict ? !I18n.getInstance().translateKey(mobInfo.getNameTranslationKey()).equalsIgnoreCase(query.query.getRight()) : !I18n.getInstance().translateKey(mobInfo.getNameTranslationKey()).toLowerCase().contains(query.query.getRight().toLowerCase())) continue;
                MobPage page = new MobPage(this, e, mobInfo);
                filtered.add(page);
            }
            this.filteredPages = Pair.of(query.rawQuery, filtered);
            return filtered;
        }
        return this.filteredPages.getRight();
    }

    private static class Index
    extends GuidebookSection.Index {
        MobInfoRegistry.MobInfo mobInfo;
        String unknownName;

        public Index(MobInfoRegistry.MobInfo mobInfo, GuidebookPage page) {
            super("", page);
            this.mobInfo = mobInfo;
            String original = I18n.getInstance().translateKey(mobInfo.getNameTranslationKey());
            this.unknownName = new String(new char[original.length()]).replace("\u0000", "?");
        }

        @Override
        public String getName() {
            boolean discovered;
            boolean bl = discovered = Minecraft.getMinecraft((Object)this).statsCounter.readStat(StatList.mobEncounterStats.get(EntityDispatcher.classToKeyMap.get(this.mobInfo.getEntityClass()))) > 0;
            if (Minecraft.getMinecraft((Object)this).thePlayer.getGamemode() == Gamemode.creative) {
                discovered = true;
            }
            if (discovered) {
                return I18n.getInstance().translateKey(this.mobInfo.getNameTranslationKey());
            }
            return this.unknownName;
        }
    }
}

