/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.entity.ArmoredZombieRenderer;
import net.minecraft.client.render.entity.ArrowRenderer;
import net.minecraft.client.render.entity.BoatRenderer;
import net.minecraft.client.render.entity.BobberRenderer;
import net.minecraft.client.render.entity.CannonballRenderer;
import net.minecraft.client.render.entity.ChickenRenderer;
import net.minecraft.client.render.entity.CowRenderer;
import net.minecraft.client.render.entity.CreeperRenderer;
import net.minecraft.client.render.entity.DefaultRenderer;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.FallingSandRenderer;
import net.minecraft.client.render.entity.FireballRenderer;
import net.minecraft.client.render.entity.FireflyRenderer;
import net.minecraft.client.render.entity.GhastRenderer;
import net.minecraft.client.render.entity.GiantRenderer;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.entity.LightningBoltRenderer;
import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.entity.MinecartRenderer;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MonsterRenderer;
import net.minecraft.client.render.entity.PaintingRenderer;
import net.minecraft.client.render.entity.PigRenderer;
import net.minecraft.client.render.entity.PlayerRenderer;
import net.minecraft.client.render.entity.ScorpionRenderer;
import net.minecraft.client.render.entity.SheepRenderer;
import net.minecraft.client.render.entity.SlimeRenderer;
import net.minecraft.client.render.entity.SnowballRenderer;
import net.minecraft.client.render.entity.SpiderRenderer;
import net.minecraft.client.render.entity.SquidRenderer;
import net.minecraft.client.render.entity.TNTRenderer;
import net.minecraft.client.render.entity.WolfRenderer;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelChicken;
import net.minecraft.client.render.model.ModelCow;
import net.minecraft.client.render.model.ModelPig;
import net.minecraft.client.render.model.ModelSheep;
import net.minecraft.client.render.model.ModelSheepOverlay;
import net.minecraft.client.render.model.ModelSheepWool;
import net.minecraft.client.render.model.ModelSkeleton;
import net.minecraft.client.render.model.ModelSlime;
import net.minecraft.client.render.model.ModelSquid;
import net.minecraft.client.render.model.ModelWolf;
import net.minecraft.client.render.model.ModelZombie;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.entity.animal.EntityCow;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.entity.monster.EntityArmoredZombie;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.entity.monster.EntityGhast;
import net.minecraft.core.entity.monster.EntityGiant;
import net.minecraft.core.entity.monster.EntityHuman;
import net.minecraft.core.entity.monster.EntityScorpion;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySlime;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityEgg;
import net.minecraft.core.entity.projectile.EntityFireball;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.Item;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EntityRenderDispatcher {
    private final Map<Class<?>, EntityRenderer<?>> renderers = new HashMap();
    public static EntityRenderDispatcher instance = new EntityRenderDispatcher();
    private FontRenderer fontRenderer;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public RenderEngine renderEngine;
    public ItemRenderer itemRenderer;
    public World world;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public GameSettings gameSettings;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private EntityRenderDispatcher() {
        this.renderers.put(EntitySpider.class, new SpiderRenderer());
        this.renderers.put(EntityScorpion.class, new ScorpionRenderer());
        this.renderers.put(EntityPig.class, new PigRenderer(new ModelPig(), new ModelPig(0.5f), 0.7f));
        this.renderers.put(EntitySheep.class, new SheepRenderer(new ModelSheep(), new ModelSheepWool(), new ModelSheepOverlay(), 0.7f));
        this.renderers.put(EntityCow.class, new CowRenderer(new ModelCow(), 0.7f));
        this.renderers.put(EntityWolf.class, new WolfRenderer(new ModelWolf(0.0f), 0.5f));
        this.renderers.put(EntityChicken.class, new ChickenRenderer(new ModelChicken(), 0.3f));
        this.renderers.put(EntityCreeper.class, new CreeperRenderer());
        this.renderers.put(EntitySkeleton.class, new MobRenderer(new ModelSkeleton(), 0.5f));
        this.renderers.put(EntityZombie.class, new MobRenderer(new ModelZombie(), 0.5f));
        this.renderers.put(EntitySnowman.class, new MobRenderer(new ModelZombie(), 0.5f));
        this.renderers.put(EntityArmoredZombie.class, new ArmoredZombieRenderer(new ModelZombie(), 0.5f));
        this.renderers.put(EntitySlime.class, new SlimeRenderer(new ModelSlime(16), new ModelSlime(0), 0.25f));
        this.renderers.put(EntityPlayer.class, new PlayerRenderer());
        this.renderers.put(EntityHuman.class, new MonsterRenderer());
        this.renderers.put(EntityGiant.class, new GiantRenderer(new ModelZombie(), 0.5f, 6.0f));
        this.renderers.put(EntityGhast.class, new GhastRenderer());
        this.renderers.put(EntitySquid.class, new SquidRenderer(new ModelSquid(), 0.7f));
        this.renderers.put(EntityLiving.class, new LivingRenderer(new ModelBiped(), 0.5f));
        this.renderers.put(Entity.class, new DefaultRenderer());
        this.renderers.put(EntityPainting.class, new PaintingRenderer());
        this.renderers.put(EntityArrow.class, new ArrowRenderer());
        this.renderers.put(EntitySnowball.class, new SnowballRenderer(Item.ammoSnowball.getIconFromDamage(0)));
        this.renderers.put(EntityEgg.class, new SnowballRenderer(Item.eggChicken.getIconFromDamage(0)));
        this.renderers.put(EntityFireball.class, new FireballRenderer());
        this.renderers.put(EntityItem.class, new ItemEntityRenderer());
        this.renderers.put(EntityTNT.class, new TNTRenderer());
        this.renderers.put(EntityFallingSand.class, new FallingSandRenderer());
        this.renderers.put(EntityMinecart.class, new MinecartRenderer());
        this.renderers.put(EntityBoat.class, new BoatRenderer());
        this.renderers.put(EntityBobber.class, new BobberRenderer());
        this.renderers.put(EntityFireflyCluster.class, new FireflyRenderer());
        this.renderers.put(EntityLightningBolt.class, new LightningBoltRenderer());
        this.renderers.put(EntityCannonball.class, new CannonballRenderer());
        this.renderers.put(EntityPebble.class, new SnowballRenderer(Item.ammoPebble.getIconFromDamage(0)));
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.setRenderDispatcher(this);
        }
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Class<? extends Entity> e) {
        EntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != Entity.class) {
            r = this.getRenderer(e.getSuperclass());
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Entity entity) {
        return this.getRenderer(entity.getClass());
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderEngine, FontRenderer fontRenderer, ICamera camera, GameSettings gameSettings, float partialTick) {
        this.world = world;
        this.renderEngine = renderEngine;
        this.gameSettings = gameSettings;
        this.fontRenderer = fontRenderer;
        this.camera = camera;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = (float)camera.getX(partialTick);
        this.viewLerpPosY = (float)camera.getY(partialTick);
        this.viewLerpPosZ = (float)camera.getZ(partialTick);
    }

    public <T extends Entity> void renderEntity(T entity, float partialTick) {
        double lerpPosX = entity.xo + (entity.x - entity.xo) * (double)partialTick;
        double lerpPosY = entity.yo + (entity.y - entity.yo) * (double)partialTick;
        double lerpPosZ = entity.zo + (entity.z - entity.zo) * (double)partialTick;
        float lerpYaw = entity.yRotO + (entity.yRot - entity.yRotO) * partialTick;
        float brightness = entity.getBrightness(partialTick);
        if (Minecraft.getMinecraft((Object)this).fullbright) {
            brightness = 1.0f;
        }
        GL11.glColor3f((float)brightness, (float)brightness, (float)brightness);
        this.renderEntityWithPosYaw(entity, lerpPosX - renderPosX, lerpPosY - renderPosY, lerpPosZ - renderPosZ, lerpYaw, partialTick);
    }

    public <T extends Entity> void renderEntityWithPosYaw(T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.doRender(entity, x, y, z, yaw, partialTick);
            renderer.doRenderShadowAndFire(entity, x, y, z, yaw, partialTick);
        }
    }

    public <T extends Entity> void renderEntityPreviewWithPosYaw(T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.doRenderPreview(entity, x, y, z, yaw, partialTick);
        }
    }

    public void unloadEntityRenderers() {
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.onUnload();
        }
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public double distanceToLerpSquared(double x, double y, double z) {
        double dx = x - this.viewLerpPosX;
        double dy = y - this.viewLerpPosY;
        double dz = z - this.viewLerpPosZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

