/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.canvas.CanvasCrashReport;
import net.minecraft.client.render.canvas.CanvasMojangLogo;
import net.minecraft.core.UnexpectedThrowable;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class PanelCrashReport
extends Panel {
    public String getStackTraceString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public PanelCrashReport(Minecraft minecraft, UnexpectedThrowable unexpectedThrowable, int cause) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setBackground(new Color(3028036));
        this.setLayout(new BorderLayout());
        String stackTrace = this.getStackTraceString(unexpectedThrowable.exception);
        String vendor = "";
        String systemProperties = "";
        try {
            systemProperties = systemProperties + "Generated " + new SimpleDateFormat().format(new Date());
            systemProperties = systemProperties + "\nMinecraft: Better than Adventure! Nightly 2024-04-09";
            systemProperties = systemProperties + "\nOS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
            systemProperties = systemProperties + "\nJava: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
            systemProperties = systemProperties + "\nVM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
            systemProperties = systemProperties + "\nLWJGL: " + Sys.getVersion();
            systemProperties = systemProperties + "\nOpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936);
            vendor = GL11.glGetString((int)7936);
        }
        catch (Throwable throwable) {
            systemProperties = systemProperties + "\n[failed to get system properties (" + throwable + ")]";
        }
        String finalCrashReport = "";
        if (stackTrace.contains("Pixel format not accelerated")) {
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\n     Bad video card drivers!";
            finalCrashReport = finalCrashReport + "\n     -----------------------";
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\nMinecraft was unable to start because it failed to find an accelerated OpenGL mode.";
            finalCrashReport = finalCrashReport + "\nThis can usually be fixed by updating the video card drivers.";
            if (vendor.toLowerCase().contains("nvidia")) {
                finalCrashReport = finalCrashReport + "\n";
                finalCrashReport = finalCrashReport + "\nYou might be able to find drivers for your video card here:";
                finalCrashReport = finalCrashReport + "\n  http://www.nvidia.com/";
            } else if (vendor.toLowerCase().contains("ati")) {
                finalCrashReport = finalCrashReport + "\n";
                finalCrashReport = finalCrashReport + "\nYou might be able to find drivers for your video card here:";
                finalCrashReport = finalCrashReport + "\n  http://www.amd.com/";
            }
        } else {
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\n     Minecraft has crashed!";
            finalCrashReport = finalCrashReport + "\n     ----------------------";
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\nMinecraft has stopped running because it encountered a problem.";
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\nIf you wish to report this, please copy this entire text and post it on the forum thread at https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely, or join the Discord server at https://discord.gg/6r3HdT53XH and post it in #bug-reports.";
            finalCrashReport = finalCrashReport + "\nPlease include a description of what you did when the error occured.";
        }
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n     System Information";
        finalCrashReport = finalCrashReport + "\n     ------------------";
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n" + systemProperties;
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n     Error Information";
        finalCrashReport = finalCrashReport + "\n     ------------------";
        finalCrashReport = finalCrashReport + "\n";
        if (cause == 2 && minecraft != null && minecraft.lastCrash != null) {
            finalCrashReport = finalCrashReport + "\nThe following exception caused the crash handler to open:";
            finalCrashReport = finalCrashReport + "\n" + this.getStackTraceString(minecraft.lastCrash.exception);
            finalCrashReport = finalCrashReport + "\n";
            finalCrashReport = finalCrashReport + "\nThe following exception occured while trying to render the crash handler:";
            finalCrashReport = finalCrashReport + "\n" + stackTrace;
        } else {
            finalCrashReport = finalCrashReport + "\n" + stackTrace;
        }
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n";
        finalCrashReport = finalCrashReport + "\n";
        JTextArea textarea = new JTextArea(finalCrashReport);
        textarea.setEditable(false);
        textarea.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)new CanvasMojangLogo(), "North");
        this.add((Component)new CanvasCrashReport(80), "East");
        this.add((Component)new CanvasCrashReport(80), "West");
        this.add((Component)new CanvasCrashReport(100), "South");
        JScrollPane scrollPane = new JScrollPane(textarea, 22, 31);
        this.add((Component)scrollPane, "Center");
    }
}

