/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.GLObject;
import org.lwjgl.opengl.GL11;

public class Texture
extends GLObject<Texture> {
    private int id;

    public Texture generate() {
        if (this.isGenerated()) {
            this.delete();
        }
        this.id = GLAllocation.generateTexture();
        if (!this.isGenerated()) {
            throw new RuntimeException("Texture not created!");
        }
        return this;
    }

    @Override
    public Texture bind() {
        if (!this.isGenerated()) {
            throw new NullPointerException();
        }
        GL11.glBindTexture((int)3553, (int)this.id);
        return this;
    }

    @Override
    public Texture unbind() {
        GL11.glBindTexture((int)3553, (int)0);
        return this;
    }

    public void delete() {
        if (!this.isGenerated()) {
            return;
        }
        GLAllocation.deleteTexture(this.id);
        this.id = 0;
    }

    @Override
    public boolean isGenerated() {
        return this.id != 0;
    }

    public int getWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public int getHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public int id() {
        return this.id;
    }
}

