/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.core.block.Block;

public class DynamicTextureWaterFlow
extends DynamicTexture {
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;
    private int ticks = 0;

    public DynamicTextureWaterFlow(int resolution) {
        super(Block.texCoordToIndex(14, 12), resolution, 2);
        this.arr1 = new float[resolution * resolution];
        this.arr2 = new float[resolution * resolution];
        this.arr3 = new float[resolution * resolution];
        this.arr4 = new float[resolution * resolution];
    }

    @Override
    public void update() {
        int g;
        int r;
        float bright;
        int j;
        int i;
        ++this.ticks;
        for (i = 0; i < this.resolution; ++i) {
            for (j = 0; j < this.resolution; ++j) {
                bright = 0.0f;
                for (int k = j - 2; k <= j; ++k) {
                    r = DynamicTextureWaterFlow.pmod(i, this.resolution);
                    g = DynamicTextureWaterFlow.pmod(k, this.resolution);
                    bright += this.arr1[r + g * this.resolution];
                }
                this.arr2[i + j * this.resolution] = bright / 3.2f + this.arr3[i + j * this.resolution] * 0.8f;
            }
        }
        for (i = 0; i < this.resolution; ++i) {
            for (j = 0; j < this.resolution; ++j) {
                int n = i + j * this.resolution;
                this.arr3[n] = this.arr3[n] + this.arr4[i + j * this.resolution] * 0.05f;
                if (this.arr3[i + j * this.resolution] < 0.0f) {
                    this.arr3[i + j * this.resolution] = 0.0f;
                }
                int n2 = i + j * this.resolution;
                this.arr4[n2] = this.arr4[n2] - 0.3f;
                if (!(Math.random() < 0.2)) continue;
                this.arr4[i + j * this.resolution] = 0.5f;
            }
        }
        float[] var12 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var12;
        for (j = 0; j < this.resolution * this.resolution; ++j) {
            bright = this.arr1[DynamicTextureWaterFlow.pmod(j - this.ticks * this.resolution, this.resolution * this.resolution)];
            if (bright > 1.0f) {
                bright = 1.0f;
            }
            if (bright < 0.0f) {
                bright = 0.0f;
            }
            float var13 = bright * bright;
            r = (int)(32.0f + var13 * 32.0f);
            g = (int)(50.0f + var13 * 64.0f);
            int b = 255;
            int a = (int)(146.0f + var13 * 50.0f);
            if (this.anaglyphEnabled) {
                int var9 = (r * 30 + g * 59 + b * 11) / 100;
                int var10 = (r * 30 + g * 70) / 100;
                int var11 = (r * 30 + b * 70) / 100;
                r = var9;
                g = var10;
                b = var11;
            }
            if (((Boolean)Minecraft.getMinecraft((Object)this).gameSettings.biomeWater.value).booleanValue()) {
                g = b = (r + g + b) / 3;
                r = b;
            }
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

