/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.Polygon;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.Vertex;
import org.lwjgl.opengl.GL11;

public class Cube {
    private Vertex[] corners;
    private Polygon[] faces;
    private final int textureU;
    private final int textureV;
    private final int texWidth;
    private final int texHeight;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean field_1402_i = false;

    public Cube(int u, int v, int texWidth, int texHeight) {
        this.textureU = u;
        this.textureV = v;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
    }

    public Cube(int u, int v) {
        this(u, v, 64, 32);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ) {
        this.addBox(minX, minY, minZ, sizeX, sizeY, sizeZ, 0.0f);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ, float expandAmount) {
        this.addBox(minX, minY, minZ, sizeX, sizeY, sizeZ, expandAmount, false);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ, float expandAmount, boolean flipBottomUV) {
        this.corners = new Vertex[8];
        this.faces = new Polygon[6];
        float maxX = minX + (float)sizeX;
        float maxY = minY + (float)sizeY;
        float maxZ = minZ + (float)sizeZ;
        minX -= expandAmount;
        minY -= expandAmount;
        minZ -= expandAmount;
        maxX += expandAmount;
        maxY += expandAmount;
        maxZ += expandAmount;
        if (this.mirror) {
            float temp = maxX;
            maxX = minX;
            minX = temp;
        }
        Vertex ptvMinXMinYMinZ = new Vertex(minX, minY, minZ, 0.0f, 0.0f);
        Vertex ptvMaxXMinYMinZ = new Vertex(maxX, minY, minZ, 0.0f, 8.0f);
        Vertex ptvMaxXMaxYMinZ = new Vertex(maxX, maxY, minZ, 8.0f, 8.0f);
        Vertex ptvMinXMaxYMinZ = new Vertex(minX, maxY, minZ, 8.0f, 0.0f);
        Vertex ptvMinXMinYMaxZ = new Vertex(minX, minY, maxZ, 0.0f, 0.0f);
        Vertex ptvMaxXMinYMaxZ = new Vertex(maxX, minY, maxZ, 0.0f, 8.0f);
        Vertex ptvMaxXMaxYMaxZ = new Vertex(maxX, maxY, maxZ, 8.0f, 8.0f);
        Vertex ptvMinXMaxYMaxZ = new Vertex(minX, maxY, maxZ, 8.0f, 0.0f);
        this.corners[0] = ptvMinXMinYMinZ;
        this.corners[1] = ptvMaxXMinYMinZ;
        this.corners[2] = ptvMaxXMaxYMinZ;
        this.corners[3] = ptvMinXMaxYMinZ;
        this.corners[4] = ptvMinXMinYMaxZ;
        this.corners[5] = ptvMaxXMinYMaxZ;
        this.corners[6] = ptvMaxXMaxYMaxZ;
        this.corners[7] = ptvMinXMaxYMaxZ;
        this.faces[0] = new Polygon(new Vertex[]{ptvMaxXMinYMaxZ, ptvMaxXMinYMinZ, ptvMaxXMaxYMinZ, ptvMaxXMaxYMaxZ}, this.textureU + sizeZ + sizeX, this.textureV + sizeZ, this.textureU + sizeZ + sizeX + sizeZ, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.faces[1] = new Polygon(new Vertex[]{ptvMinXMinYMinZ, ptvMinXMinYMaxZ, ptvMinXMaxYMaxZ, ptvMinXMaxYMinZ}, this.textureU, this.textureV + sizeZ, this.textureU + sizeZ, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.faces[2] = new Polygon(new Vertex[]{ptvMaxXMinYMaxZ, ptvMinXMinYMaxZ, ptvMinXMinYMinZ, ptvMaxXMinYMinZ}, this.textureU + sizeZ, this.textureV, this.textureU + sizeZ + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
        if (flipBottomUV) {
            this.faces[3] = new Polygon(new Vertex[]{ptvMaxXMaxYMaxZ, ptvMinXMaxYMaxZ, ptvMinXMaxYMinZ, ptvMaxXMaxYMinZ}, this.textureU + sizeZ + sizeX, this.textureV, this.textureU + sizeZ + sizeX + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
            this.faces[3].invertNormal = true;
        } else {
            this.faces[3] = new Polygon(new Vertex[]{ptvMaxXMaxYMinZ, ptvMinXMaxYMinZ, ptvMinXMaxYMaxZ, ptvMaxXMaxYMaxZ}, this.textureU + sizeZ + sizeX, this.textureV, this.textureU + sizeZ + sizeX + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
        }
        this.faces[4] = new Polygon(new Vertex[]{ptvMaxXMinYMinZ, ptvMinXMinYMinZ, ptvMinXMaxYMinZ, ptvMaxXMaxYMinZ}, this.textureU + sizeZ, this.textureV + sizeZ, this.textureU + sizeZ + sizeX, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.faces[5] = new Polygon(new Vertex[]{ptvMinXMinYMaxZ, ptvMaxXMinYMaxZ, ptvMaxXMaxYMaxZ, ptvMinXMaxYMaxZ}, this.textureU + sizeZ + sizeX + sizeZ, this.textureV + sizeZ, this.textureU + sizeZ + sizeX + sizeZ + sizeX, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        if (this.mirror) {
            for (Polygon face : this.faces) {
                face.flipFace();
            }
        }
    }

    public void setRotationPoint(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
    }

    public void setRotationAngle(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
    }

    public void render(float scale) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(scale);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void renderWithRotation(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
    }

    public void postRender(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i].draw(tessellator, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

