/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.Global;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockChestPainted
extends BlockChest {
    public static final int colorBits = 240;
    public static final int colorOffset = 4;

    protected BlockChestPainted(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, meta & 0xF0)};
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int color = blockAccess.getBlockMetadata(x, y, z) >> 4;
        int texOffset = BlockChestPainted.texCoordToIndex(20, 28) - (color % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * 3) + color / 4 * 3);
        return super.getBlockTexture(blockAccess, x, y, z, side) + texOffset;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4;
        int texOffset = BlockChestPainted.texCoordToIndex(20, 28) - (color % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * 3) + color / 4 * 3);
        return super.getBlockTextureFromSideAndMetadata(side, data & 0xF) + texOffset;
    }

    public static int getMetaForDyeColor(int i) {
        return ~i << 4 & 0xF0;
    }
}

