/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFenceGate;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockFenceGatePainted
extends BlockFenceGate {
    public static final int[] texCoords = new int[16];
    public static int TEX_COORD_OFFSET = 3;

    public BlockFenceGatePainted(String key, int id) {
        super(key, id);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return texCoords[(meta >>= 4) & 0xF];
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, meta & 0xF0)};
    }

    public static int getMetadataForColour(int i) {
        return ~i << 4 & 0xF0;
    }

    static {
        BlockFenceGatePainted.texCoords[0] = Block.texCoordToIndex(31, 30);
        for (int i = 1; i < 16; ++i) {
            BlockFenceGatePainted.texCoords[i] = texCoords[0] - (i % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * TEX_COORD_OFFSET) + i / 4 * TEX_COORD_OFFSET);
        }
    }
}

