/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public abstract class BlockFenceThin
extends Block {
    public BlockFenceThin(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        boolean connectXPos = this.canConnectTo(world, x + 1, y, z);
        boolean connectXNeg = this.canConnectTo(world, x - 1, y, z);
        boolean connectZPos = this.canConnectTo(world, x, y, z + 1);
        boolean connectZNeg = this.canConnectTo(world, x, y, z - 1);
        return AABB.getBoundingBoxFromPool((float)x + (connectXNeg ? 0.0f : 0.375f), y, (float)z + (connectZNeg ? 0.0f : 0.375f), (float)(x + 1) - (connectXPos ? 0.0f : 0.375f), (float)y + 1.0f, (float)(z + 1) - (connectZPos ? 0.0f : 0.375f));
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        AABB aabb = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        this.minX = aabb.minX - (double)x;
        this.minY = aabb.minY - (double)y;
        this.minZ = aabb.minZ - (double)z;
        this.maxX = aabb.maxX - (double)x;
        this.maxY = aabb.maxY - (double)y;
        this.maxZ = aabb.maxZ - (double)z;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public abstract boolean canConnectTo(WorldSource var1, int var2, int var3, int var4);

    public abstract boolean shouldDrawColumn(World var1, int var2, int var3, int var4);

    public abstract int getTextureIndex();

    public abstract int getTextureIndexAtTop();

    public abstract int getTextureIndexAtBottom();

    public abstract int getColumnTextureIndex();
}

