/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockSign
extends BlockTileEntity {
    private Class signEntityClass;
    private boolean isFreestanding;

    public BlockSign(String key, int id, Class class1, boolean flag) {
        super(key, id, Material.wood);
        this.isFreestanding = flag;
        this.signEntityClass = class1;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        if (this.isFreestanding) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (l == 2) {
            this.setBlockBounds(f2, f, 1.0f - f4, f3, f1, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(f2, f, 0.0f, f3, f1, f4);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f4, f, f2, 1.0f, f1, f3);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, f, f2, f4, f1, f3);
        }
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        try {
            return (TileEntity)this.signEntityClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag = false;
        if (this.isFreestanding) {
            if (!world.getBlockMaterial(x, y - 1, z).isSolid()) {
                flag = true;
            }
        } else {
            int i1 = world.getBlockMetadata(x, y, z);
            flag = true;
            if (i1 == 2 && world.getBlockMaterial(x, y, z + 1).isSolid()) {
                flag = false;
            }
            if (i1 == 3 && world.getBlockMaterial(x, y, z - 1).isSolid()) {
                flag = false;
            }
            if (i1 == 4 && world.getBlockMaterial(x + 1, y, z).isSolid()) {
                flag = false;
            }
            if (i1 == 5 && world.getBlockMaterial(x - 1, y, z).isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
        super.onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Item.sign)};
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        TileEntitySign tileentitysign = (TileEntitySign)world.getBlockTileEntity(x, y, z);
        if (tileentitysign != null && tileentitysign.getIsEditable(player)) {
            player.displayGUIEditSign(tileentitysign);
            return true;
        }
        return false;
    }
}

