/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeEntryRepairable
extends RecipeEntryCraftingDynamic {
    public Item inItem;
    public Item repairMaterial;
    public ItemStack inItemStack;

    public RecipeEntryRepairable(Item inItem, Item repairMaterial) {
        this.inItem = inItem;
        this.repairMaterial = repairMaterial;
        this.inItemStack = new ItemStack(inItem);
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int repairMaterialCount = 0;
        int inItemCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.repairMaterial.id) {
                    ++repairMaterialCount;
                    continue;
                }
                if (stack.itemID == this.inItem.id) {
                    ++inItemCount;
                    continue;
                }
                return false;
            }
        }
        if (repairMaterialCount == 0) {
            return false;
        }
        return inItemCount == 1;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        int repairMaterialCount = 0;
        ItemStack inItemStack = null;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.repairMaterial.id) {
                    ++repairMaterialCount;
                    continue;
                }
                if (stack.itemID != this.inItem.id) continue;
                inItemStack = stack.copy();
            }
        }
        for (int i = 0; i < repairMaterialCount; ++i) {
            if (inItemStack.getMetadata() >= inItemStack.getMaxDamage()) continue;
            inItemStack.setMetadata(inItemStack.getMetadata() - inItemStack.getMaxDamage() / 8);
        }
        if (inItemStack.getMetadata() < 0) {
            inItemStack.setMetadata(0);
        }
        return inItemStack;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                ItemStack stack2 = stack.stackSize - 1 == 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - 1);
                inventorycrafting.setSlotContentsAt(x, y, stack2);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }
}

