/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityPigZombie
extends EntityZombie {
    private int angerLevel = 0;
    private int randomSoundDelay = 0;
    private static final ItemStack defaultHeldItem = new ItemStack(Item.toolSwordGold, 1);

    public EntityPigZombie(World world) {
        super(world);
        this.skinName = "pigzombie";
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.fireImmune = false;
        this.scoreValue = 500;
    }

    @Override
    public void tick() {
        float f = this.moveSpeed = this.entityToAttack == null ? 0.5f : 0.95f;
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.world.playSoundAtEntity(null, this, "mob.zombiepig.zpigangry", this.getSoundVolume() * 2.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 1.8f);
        }
        super.tick();
    }

    @Override
    public boolean getCanSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor_double(this.x);
        if (this.world.getBlockId(x, y = MathHelper.floor_double(this.y), z = MathHelper.floor_double(this.z)) != 0) {
            return false;
        }
        int blockLight = this.world.getSavedLightValue(LightLayer.Block, x, y, z);
        if (blockLight > 7) {
            return false;
        }
        return this.world.difficultySetting > 0 && this.world.checkIfAABBIsClear(this.bb) && this.world.getCubes(this, this.bb).size() == 0 && !this.world.getIsAnyLiquid(this.bb);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("Anger", (short)this.angerLevel);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.angerLevel = tag.getShort("Anger");
    }

    @Override
    protected Entity findPlayerToAttack() {
        if (this.angerLevel == 0) {
            return null;
        }
        return super.findPlayerToAttack();
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (type == DamageType.FIRE) {
            return false;
        }
        if (attacker instanceof EntityPlayer) {
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(32.0, 32.0, 32.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = list.get(j);
                if (!(entity1 instanceof EntityPigZombie)) continue;
                EntityPigZombie entitypigzombie = (EntityPigZombie)entity1;
                entitypigzombie.becomeAngryAt(attacker);
            }
            this.becomeAngryAt(attacker);
        }
        return super.hurt(attacker, i, type);
    }

    private void becomeAngryAt(Entity entity) {
        this.entityToAttack = entity;
        this.angerLevel = 400 + this.random.nextInt(400);
        this.randomSoundDelay = this.random.nextInt(40);
    }

    @Override
    public String getLivingSound() {
        return "mob.zombiepig.zpig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiepig.zpighurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiepig.zpigdeath";
    }

    @Override
    protected void dropFewItems() {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.random.nextInt(2);
            for (int k = 0; k < j; ++k) {
                this.spawnAtLocation(i, 1);
            }
        }
    }

    @Override
    protected int getDropItemId() {
        float drop = this.world.rand.nextFloat();
        if (drop < 0.5f) {
            return 0;
        }
        if (drop < 0.95f) {
            if (this.isOnFire()) {
                return Item.foodPorkchopCooked.id;
            }
            return Item.foodPorkchopRaw.id;
        }
        if (drop < 0.99f) {
            return Item.oreRawGold.id;
        }
        return Item.toolSwordGold.id;
    }

    @Override
    public ItemStack getHeldItem() {
        return defaultHeldItem;
    }
}

