/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.player;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockBed;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.entity.monster.EntityGhast;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.enums.EnumArt;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.Weather;

public abstract class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory;
    public Container inventorySlots;
    public Container craftingInventory;
    public Gamemode gamemode = Gamemode.survival;
    public byte field_9371_f = 0;
    public int score = 0;
    public List<String> messages = new ArrayList<String>();
    public float field_775_e;
    public float field_774_f;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public int dimension;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    protected boolean sleeping;
    public ChunkCoordinates bedChunkCoordinates;
    private int sleepTimer;
    public float field_22063_x;
    public float field_22062_y;
    public float field_22061_z;
    private ChunkCoordinates playerSpawnCoordinate;
    private ChunkCoordinates lastDeathCoordinate;
    private ChunkCoordinates startMinecartRidingCoordinate;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public int portalID;
    public float timeInPortal;
    public float prevTimeInPortal;
    private final int damageRemainder;
    public EntityBobber fishEntity = null;
    public volatile String skinURL;
    public volatile String capeURL;
    public boolean slimModel = false;
    protected float baseSpeed = 0.1f;
    protected float baseFlySpeed = 0.02f;
    protected boolean isDwarf = false;

    public EntityPlayer(World world) {
        super(world);
        this.inventory = new InventoryPlayer(this);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !world.isClientSide);
        this.heightOffset = 1.62f;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        this.moveTo((double)chunkcoordinates.x + 0.5, chunkcoordinates.y + 1, (double)chunkcoordinates.z + 0.5, 0.0f, 0.0f);
        this.entityType = "humanoid";
        this.unusedRotation2 = 180.0f;
        this.fireImmuneTicks = 20;
        this.skinName = "char";
        this.damageRemainder = 0;
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    public EnumArt getSelectedArt() {
        return EnumArt.values()[this.entityData.getByte(17)];
    }

    public void setSelectedArt(EnumArt selectedArt) {
        this.entityData.set(17, (byte)selectedArt.ordinal());
    }

    private void setupDwarfMode() {
        boolean dwarfModeEnabled = this.world.getGameRule(GameRules.DWARF_MODE);
        if (dwarfModeEnabled && !this.isDwarf) {
            this.setSize(0.6f, 0.8f);
            this.heightOffset = 0.62f;
            this.setPos(this.x, this.y - 1.0, this.z);
        } else if (!dwarfModeEnabled && this.isDwarf) {
            this.setSize(0.6f, 1.8f);
            this.heightOffset = 1.62f;
            this.setPos(this.x, this.y + 1.0, this.z);
        }
        this.isDwarf = dwarfModeEnabled;
    }

    public boolean isDwarf() {
        return this.isDwarf;
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)0);
        this.entityData.define(17, (byte)0);
    }

    @Override
    public boolean canSkate() {
        return this.inventory.armorInventory[0] != null && this.inventory.armorInventory[0].itemID == Item.armorBootsIceskates.id;
    }

    @Override
    public void tick() {
        this.setupDwarfMode();
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.world.isClientSide) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true);
                } else if (this.world.isDaytime() && this.world.getCurrentWeather() != Weather.overworldStorm) {
                    this.wakeUpPlayer(false, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.tick();
        if (!this.world.isClientSide && this.craftingInventory != null && !this.craftingInventory.isUsableByPlayer(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d = this.x - this.field_20063_u;
        double d1 = this.y - this.field_20062_v;
        double d2 = this.z - this.field_20061_w;
        double d3 = 10.0;
        if (d > d3) {
            this.field_20066_r = this.field_20063_u = this.x;
        }
        if (d2 > d3) {
            this.field_20064_t = this.field_20061_w = this.z;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.y;
        }
        if (d < -d3) {
            this.field_20066_r = this.field_20063_u = this.x;
        }
        if (d2 < -d3) {
            this.field_20064_t = this.field_20061_w = this.z;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.y;
        }
        this.field_20063_u += d * 0.25;
        this.field_20061_w += d2 * 0.25;
        this.field_20062_v += d1 * 0.25;
        this.addStat(StatList.minutesPlayedStat, 1);
        if (this.vehicle == null) {
            this.startMinecartRidingCoordinate = null;
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0 || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    @Override
    public void rideTick() {
        double d = this.x;
        double d1 = this.y;
        double d2 = this.z;
        super.rideTick();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
        this.addMountedMovementStat(this.x - d, this.y - d1, this.z - d2);
    }

    @Override
    public void resetPos() {
        this.heightOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.resetPos();
        this.setHealthRaw(this.getMaxHealth());
        this.deathTime = 0;
        this.setupDwarfMode();
    }

    @Override
    protected void updatePlayerActionState() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    @Override
    public void onLivingUpdate() {
        List<Entity> list;
        if (this.world.difficultySetting == 0 && this.getHealth() < this.getMaxHealth() && this.tickCount % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.field_775_e = this.field_774_f;
        super.onLivingUpdate();
        this.speed = this.baseSpeed;
        this.flySpeed = this.baseFlySpeed;
        if (this.isSprinting()) {
            this.speed = (float)((double)this.speed + (double)this.baseSpeed * 0.3);
            this.flySpeed = (float)((double)this.flySpeed + (double)this.baseFlySpeed * 0.3);
        }
        float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        float f1 = (float)Math.atan(-this.yd * 0.2) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (f - this.field_774_f) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
        if (!this.dead && this.lastDeathCoordinate != null && this.distanceTo(this.lastDeathCoordinate.x, this.lastDeathCoordinate.y, this.lastDeathCoordinate.z) < 8.0) {
            this.lastDeathCoordinate = null;
        }
        if (this.getHealth() > 0 && (list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(1.0, 0.5, 1.0))) != null) {
            for (Entity entity : list) {
                if (entity.removed) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    @Override
    public void playHurtSound() {
        float pitch = 1.0f;
        if (this.world.getGameRule(GameRules.DWARF_MODE).booleanValue()) {
            pitch = 2.0f;
        }
        this.world.playSoundAtEntity(null, this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + pitch);
    }

    @Override
    public void playDeathSound() {
        float pitch = 1.0f;
        if (this.world.getGameRule(GameRules.DWARF_MODE).booleanValue()) {
            pitch = 2.0f;
        }
        this.world.playSoundAtEntity(null, this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + pitch);
    }

    private void collideWithPlayer(Entity entity) {
        entity.playerTouch(this);
        String entityName = EntityDispatcher.getEntityString(entity);
        this.addStat(StatList.mobEncounterStats.get(entityName), 1);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void onDeath(Entity entity) {
        super.onDeath(entity);
        this.setSize(0.2f, 0.2f);
        this.setPos(this.x, this.y, this.z);
        this.lastDeathCoordinate = new ChunkCoordinates((int)this.x, (int)this.y, (int)this.z);
        this.yd = 0.1;
        if (this.username.equals("MaggAndGeez")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.ammoFireball, 1), true);
        } else if (this.username.equals("jonkadelic")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.foodCookie, 1), true);
        } else if (this.username.equals("AnActualSign")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.sign, 1), true);
        }
        if (!this.world.getGameRule(GameRules.KEEP_INVENTORY).booleanValue()) {
            this.craftingInventory.onCraftGuiClosed(this);
            this.inventory.dropAllItems();
        }
        if (entity != null) {
            this.xd = -MathHelper.cos((this.attackedAtYaw + this.yRot) * 3.141593f / 180.0f) * 0.1f;
            this.zd = -MathHelper.sin((this.attackedAtYaw + this.yRot) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.zd = 0.0;
            this.xd = 0.0;
        }
        this.heightOffset = 0.1f;
        this.addStat(StatList.deathsStat, 1);
    }

    @Override
    protected void dropFewItems() {
    }

    @Override
    public void awardKillScore(Entity entity, int i) {
        this.score += i;
        if (entity instanceof EntityPlayer) {
            this.addStat(StatList.playerKillsStat, 1);
        } else {
            this.addStat(StatList.mobKillsStat, 1);
        }
    }

    public void dropCurrentItem(boolean dropFullStack) {
        this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, dropFullStack ? 64 : 1), false);
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropPlayerItemWithRandomChoice(itemstack, false);
    }

    public void setHotbarOffset(int offset) {
        this.inventory.hotbarOffset = offset;
    }

    @Override
    public void push(Entity entity) {
        if (this.noPhysics) {
            return;
        }
        super.push(entity);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack itemstack, boolean flag) {
        if (itemstack == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.world, this.x, this.y - (double)0.3f + (double)this.getHeadHeight(), this.z, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        float f = 0.1f;
        if (flag) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f4 = this.random.nextFloat() * 3.141593f * 2.0f;
            entityitem.xd = -MathHelper.sin(f4) * f2;
            entityitem.zd = MathHelper.cos(f4) * f2;
            entityitem.yd = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.xd = -MathHelper.sin(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f1;
            entityitem.zd = MathHelper.cos(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f) * f1;
            entityitem.yd = -MathHelper.sin(this.xRot / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.random.nextFloat() * 3.141593f * 2.0f;
            entityitem.xd += Math.cos(f3) * (double)(f1 *= this.random.nextFloat());
            entityitem.yd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            entityitem.zd += Math.sin(f3) * (double)f1;
        }
        this.joinEntityItemWithWorld(entityitem);
        this.addStat(StatList.dropStat, 1);
    }

    protected void joinEntityItemWithWorld(EntityItem entityitem) {
        this.world.entityJoinedWorld(entityitem);
    }

    public float getCurrentPlayerStrVsBlock(Block block) {
        float f = this.inventory.getStrVsBlock(block);
        if (this.isUnderLiquid(Material.water)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean canHarvestBlock(Block block) {
        if (block == null) {
            return false;
        }
        return this.inventory.canHarvestBlock(block);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag nbttaglist = tag.getList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        int dim = tag.getInteger("Dimension");
        if (dim == -1) {
            dim = 1;
        }
        this.dimension = dim;
        this.sleeping = tag.getBoolean("Sleeping");
        this.sleepTimer = tag.getShort("SleepTimer");
        this.setGamemodeOnLogin(Gamemode.gamemodesList[tag.getInteger("Gamemode")]);
        boolean bl = this.noPhysics = tag.getBoolean("Noclip") && this.gamemode.canPlayerFly();
        if (this.sleeping) {
            this.bedChunkCoordinates = new ChunkCoordinates(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z));
            this.wakeUpPlayer(true, true);
        }
        if (tag.containsKey("SpawnX") && tag.containsKey("SpawnY") && tag.containsKey("SpawnZ")) {
            this.playerSpawnCoordinate = new ChunkCoordinates(tag.getInteger("SpawnX"), tag.getInteger("SpawnY"), tag.getInteger("SpawnZ"));
        }
        if (tag.containsKey("LastDeathX") && tag.containsKey("LastDeathY") && tag.containsKey("LastDeathZ")) {
            this.lastDeathCoordinate = new ChunkCoordinates(tag.getInteger("LastDeathX"), tag.getInteger("LastDeathY"), tag.getInteger("LastDeathZ"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", this.inventory.writeToNBT(new ListTag()));
        tag.putInt("Dimension", this.dimension);
        tag.putBoolean("Sleeping", this.sleeping);
        tag.putShort("SleepTimer", (short)this.sleepTimer);
        tag.putInt("Gamemode", this.gamemode.getId());
        tag.putBoolean("Noclip", this.noPhysics && this.gamemode.canPlayerFly());
        if (this.playerSpawnCoordinate != null) {
            tag.putInt("SpawnX", this.playerSpawnCoordinate.x);
            tag.putInt("SpawnY", this.playerSpawnCoordinate.y);
            tag.putInt("SpawnZ", this.playerSpawnCoordinate.z);
        }
        if (this.lastDeathCoordinate != null) {
            tag.putInt("LastDeathX", this.lastDeathCoordinate.x);
            tag.putInt("LastDeathY", this.lastDeathCoordinate.y);
            tag.putInt("LastDeathZ", this.lastDeathCoordinate.z);
        }
    }

    @Override
    public String getDisplayName() {
        String name = this.nickname;
        name = name.isEmpty() ? this.username : TextFormatting.ITALIC + name;
        return TextFormatting.get(this.chatColor) + name;
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayGUIWorkbench(int i, int j, int k) {
    }

    public void displayGUIEditLabel(ItemStack itemstack, int slot) {
    }

    public void displayGUIPaintingPicker() {
    }

    public void displayGUIMobSpawnerPicker(int x, int y, int z) {
    }

    public void onItemPickup(Entity entity, int i) {
    }

    @Override
    public float getHeadHeight() {
        return 0.12f;
    }

    protected void resetHeight() {
        this.heightOffset = this.getHeightOffset();
    }

    public float getHeightOffset() {
        if (this.isDwarf) {
            return 0.62f;
        }
        return 1.62f;
    }

    public boolean killPlayer() {
        return super.hurt(null, 100, null);
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        this.entityAge = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        if (this.gamemode.isPlayerInvulnerable()) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.world.isClientSide) {
            this.wakeUpPlayer(true, true);
        }
        if (attacker instanceof EntityMonster || attacker instanceof EntityArrow) {
            if (this.world.difficultySetting == 0) {
                damage = 0;
            }
            if (this.world.difficultySetting == 1) {
                damage = damage / 3 + 1;
            }
            if (this.world.difficultySetting == 3) {
                damage = damage * 3 / 2;
            }
        }
        Entity obj = attacker;
        if (damage == 0 && !(attacker instanceof EntitySnowman)) {
            return false;
        }
        if (obj instanceof EntityArrow && ((EntityArrow)obj).owner != null) {
            obj = ((EntityArrow)obj).owner;
        }
        if (obj instanceof EntityLiving) {
            this.alertWolves((EntityLiving)obj, false);
        }
        this.addStat(StatList.damageTakenStat, damage);
        if (attacker != null) {
            String entityName = EntityDispatcher.getEntityString(attacker);
            this.addStat(StatList.mobEncounterStats.get(entityName), 1);
        }
        return super.hurt(attacker, damage, type);
    }

    protected boolean func_27025_G() {
        return false;
    }

    protected void alertWolves(EntityLiving entityliving, boolean flag) {
        EntityWolf entitywolf;
        if (entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast) {
            return;
        }
        if (entityliving instanceof EntityWolf && (entitywolf = (EntityWolf)entityliving).isWolfTamed() && this.username.equals(entitywolf.getWolfOwner())) {
            return;
        }
        if (entityliving instanceof EntityPlayer && !this.func_27025_G()) {
            return;
        }
        List<Entity> list = this.world.getEntitiesWithinAABB(EntityWolf.class, AABB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).expand(16.0, 4.0, 16.0));
        for (Entity entity : list) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (!entitywolf1.isWolfTamed() || entitywolf1.getTarget() != null || !this.username.equals(entitywolf1.getWolfOwner()) || flag && entitywolf1.isWolfSitting()) continue;
            entitywolf1.setWolfSitting(false);
            entitywolf1.setTarget(entityliving);
        }
    }

    @Override
    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (damageType != null && damageType.shouldDamageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            this.inventory.damageArmor(armorDamage);
        }
        super.damageEntity(newDamage, damageType);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUITrommel(TileEntityTrommel tileEntityTrommel) {
    }

    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIGuidebook(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    public void displayGUIEditFlag(TileEntityFlag tileEntityFlag) {
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public void useCurrentItemOnEntity(Entity entity) {
        if (entity.interact(this)) {
            this.swingItem();
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            if (itemstack.useItemOnEntity((EntityLiving)entity, this)) {
                this.swingItem();
            }
            if (itemstack.stackSize <= 0) {
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double getRidingHeight() {
        return this.isDwarf ? (double)this.heightOffset + 0.05 : (double)(this.heightOffset - 0.5f);
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        int i = this.inventory.getDamageVsEntity(entity);
        if (i > 0) {
            if (this.yd < 0.0) {
                ++i;
            }
            entity.hurt(this, i, DamageType.COMBAT);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity, this);
                if (itemstack.stackSize <= 0) {
                    this.destroyCurrentEquippedItem();
                }
            }
            if (entity instanceof EntityLiving) {
                if (entity.isAlive()) {
                    this.alertWolves((EntityLiving)entity, true);
                }
                this.addStat(StatList.damageDealtStat, i);
            }
        }
        String entityName = EntityDispatcher.getEntityString(entity);
        this.addStat(StatList.mobEncounterStats.get(entityName), 1);
    }

    public void respawnPlayer() {
    }

    public abstract void func_6420_o();

    public void onItemStackChanged(ItemStack itemstack) {
    }

    @Override
    public void remove() {
        super.remove();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    @Override
    public boolean isInWall() {
        return !this.sleeping && super.isInWall();
    }

    public EnumSleepStatus sleepInBedAt(int x, int y, int z) {
        if (!this.world.isClientSide) {
            if (this.isPlayerSleeping() || !this.isAlive()) {
                return EnumSleepStatus.OTHER_PROBLEM;
            }
            if (!this.world.worldType.mayRespawn()) {
                return EnumSleepStatus.NOT_POSSIBLE_HERE;
            }
            if (Math.abs(this.x - (double)x) > 3.0 || Math.abs(this.y - (double)y) > 3.0 || Math.abs(this.z - (double)z) > 3.0) {
                return EnumSleepStatus.TOO_FAR_AWAY;
            }
            if (!(this.bedChunkCoordinates != null && this.bedChunkCoordinates.equals(x, y, z) || this.playerSpawnCoordinate != null && this.playerSpawnCoordinate.equals(x, y, z))) {
                this.addChatMessage("bed.setSpawn");
                this.setPlayerSpawnCoordinate(new ChunkCoordinates(x, y, z));
            }
            if (!this.world.getGameRule(GameRules.ALLOW_SLEEPING).booleanValue()) {
                this.addChatMessage("bed.noAllowSleeping");
                return EnumSleepStatus.DISABLED_BY_GAMERULE;
            }
            if (this.world.isDaytime() && this.world.getCurrentWeather() != Weather.overworldStorm) {
                this.addChatMessage("bed.noSleep");
                return EnumSleepStatus.NOT_POSSIBLE_NOW;
            }
        }
        this.setPlayerSleeping(x, y, z);
        return EnumSleepStatus.OK;
    }

    private void setPlayerSleeping(int x, int y, int z) {
        this.setSize(0.2f, 0.2f);
        this.heightOffset = 0.2f;
        if (this.world.isBlockLoaded(x, y, z)) {
            int meta = this.world.getBlockMetadata(x, y, z);
            int dir = BlockBed.getDirectionFromMetadata(meta);
            float xOff = 0.5f;
            float zOff = 0.5f;
            if (dir == 0) {
                zOff = 0.9f;
            } else if (dir == 1) {
                xOff = 0.1f;
            } else if (dir == 2) {
                zOff = 0.1f;
            } else if (dir == 3) {
                xOff = 0.9f;
            }
            this.func_22052_e(dir);
            this.setPos((float)x + xOff, (float)y + 0.9375f, (float)z + zOff);
        } else {
            this.setPos((float)x + 0.5f, (float)y + 0.9375f, (float)z + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xd = 0.0;
        this.bedChunkCoordinates = new ChunkCoordinates(x, y, z);
        if (!this.world.isClientSide) {
            this.world.updateEnoughPlayersSleepingFlag(this);
        }
    }

    private void func_22052_e(int i) {
        this.field_22063_x = 0.0f;
        this.field_22061_z = 0.0f;
        switch (i) {
            case 0: {
                this.field_22061_z = -1.8f;
                break;
            }
            case 2: {
                this.field_22061_z = 1.8f;
                break;
            }
            case 1: {
                this.field_22063_x = 1.8f;
                break;
            }
            case 3: {
                this.field_22063_x = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean flag, boolean flag1) {
        this.setSize(0.6f, 1.8f);
        this.resetHeight();
        ChunkCoordinates chunkcoordinates = this.bedChunkCoordinates;
        if (chunkcoordinates != null && this.world.getBlock(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z) instanceof BlockBed) {
            BlockBed.setBedOccupied(this.world, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, false);
            ChunkCoordinates chunkcoordinates2 = BlockBed.getNearestEmptyChunkCoordinates(this.world, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, 0);
            if (chunkcoordinates2 == null) {
                chunkcoordinates2 = new ChunkCoordinates(chunkcoordinates.x, chunkcoordinates.y + 1, chunkcoordinates.z);
            }
            this.setPos((float)chunkcoordinates2.x + 0.5f, (float)chunkcoordinates2.y + this.heightOffset + 0.1f, (float)chunkcoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isClientSide && flag1) {
            this.world.updateEnoughPlayersSleepingFlag(this);
        }
        this.sleepTimer = flag ? 0 : 100;
    }

    private boolean isInBed() {
        return this.world.getBlock(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z) instanceof BlockBed;
    }

    public static ChunkCoordinates getValidBedSpawnCoordinates(World world, ChunkCoordinates coords) {
        IChunkProvider chunkProvider = world.getChunkProvider();
        chunkProvider.setCurrentChunkOver(coords.x >> 4, coords.z >> 4);
        chunkProvider.prepareChunk(coords.x - 3 >> 4, coords.z - 3 >> 4);
        chunkProvider.prepareChunk(coords.x + 3 >> 4, coords.z - 3 >> 4);
        chunkProvider.prepareChunk(coords.x - 3 >> 4, coords.z + 3 >> 4);
        chunkProvider.prepareChunk(coords.x + 3 >> 4, coords.z + 3 >> 4);
        if (world.getBlock(coords.x, coords.y, coords.z) instanceof BlockBed) {
            return BlockBed.getNearestEmptyChunkCoordinates(world, coords.x, coords.y, coords.z, 0);
        }
        return null;
    }

    public float getBedOrientationInDegrees() {
        if (this.bedChunkCoordinates != null) {
            int i = this.world.getBlockMetadata(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z);
            int j = BlockBed.getDirectionFromMetadata(i);
            switch (j) {
                case 0: {
                    return 90.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 270.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int getSleepTimer() {
        return this.sleepTimer;
    }

    public void addChatMessage(String s) {
    }

    @Override
    public ItemStack getHeldItem() {
        return this.inventory.getCurrentItem();
    }

    public void updateCreativeInventory(int page, String searchText) {
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates chunkcoordinates) {
        this.playerSpawnCoordinate = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates) : null;
    }

    public void triggerAchievement(Stat statbase) {
        this.addStat(statbase, 1);
    }

    public void addStat(Stat statbase, int i) {
    }

    public int getStat(Stat statbase) {
        return 0;
    }

    @Override
    protected void jump() {
        super.jump();
        this.addStat(StatList.jumpStat, 1);
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        double d = this.x;
        double d1 = this.y;
        double d2 = this.z;
        super.moveEntityWithHeading(moveStrafing, moveForward);
        this.addMovementStat(this.x - d, this.y - d1, this.z - d2);
    }

    private void addMovementStat(double d, double d1, double d2) {
        if (this.vehicle != null) {
            return;
        }
        if (this.isUnderLiquid(Material.water)) {
            int i = Math.round(MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2) * 100.0f);
            if (i > 0) {
                this.addStat(StatList.distanceDoveStat, i);
            }
        } else if (this.isInWater()) {
            int j = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
            if (j > 0) {
                this.addStat(StatList.distanceSwumStat, j);
            }
        } else if (this.canClimb()) {
            if (d1 > 0.0) {
                this.addStat(StatList.distanceClimbedStat, (int)Math.round(d1 * 100.0));
            }
        } else if (this.onGround) {
            int k = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
            if (k > 0) {
                this.addStat(StatList.distanceWalkedStat, k);
            }
        } else {
            int l = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
            if (l > 25) {
                this.addStat(StatList.distanceFlownStat, l);
            }
        }
    }

    private void addMountedMovementStat(double d, double d1, double d2) {
        int i;
        if (this.vehicle != null && (i = Math.round(MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2) * 100.0f)) > 0) {
            if (this.vehicle instanceof EntityMinecart) {
                this.addStat(StatList.distanceByMinecartStat, i);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new ChunkCoordinates(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z));
                } else if (this.startMinecartRidingCoordinate.getSqDistanceTo(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)) >= 1000.0) {
                    this.addStat(AchievementList.ON_A_RAIL, 1);
                }
            } else if (this.vehicle instanceof EntityBoat) {
                this.addStat(StatList.distanceByBoatStat, i);
            } else if (this.vehicle instanceof EntityPig) {
                this.addStat(StatList.distanceByPigStat, i);
            }
        }
    }

    @Override
    protected void causeFallDamage(float f) {
        if (f >= 2.0f) {
            this.addStat(StatList.distanceFallenStat, (int)Math.round((double)f * 100.0));
        }
        super.causeFallDamage(f);
    }

    @Override
    public void killed(EntityLiving entityliving) {
        if (entityliving instanceof EntityMonster) {
            this.triggerAchievement(AchievementList.KILL_ENEMY);
        }
    }

    @Override
    public int getItemIcon(ItemStack itemstack) {
        int i = super.getItemIcon(itemstack);
        if (itemstack.itemID == Item.toolFishingrod.id && this.fishEntity != null) {
            i = Item.iconCoordToIndex(5, 5);
        }
        return i;
    }

    @Override
    public void handlePortal(int portalTileId) {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
        } else {
            this.portalID = portalTileId;
            this.inPortal = true;
        }
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.gamemode.isPlayerInvulnerable();
    }

    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemodeOnLogin(Gamemode gamemode) {
        this.gamemode = gamemode;
        ContainerPlayer newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    public void setGamemode(Gamemode gamemode) {
    }

    public void setNoclip(boolean noclip) {
        this.noPhysics = noclip;
        if (this.noPhysics) {
            this.yd += (double)0.079f;
        }
    }

    public void setLastDeathCoordinate(ChunkCoordinates lastDeathCoordinate) {
        this.lastDeathCoordinate = lastDeathCoordinate;
    }

    public ChunkCoordinates getLastDeathCoordinate() {
        return this.lastDeathCoordinate;
    }

    public void pickBlock(int x, int y, int z) {
        ItemStack selectItem;
        Block block = this.world.getBlock(x, y, z);
        int meta = this.world.getBlockMetadata(x, y, z);
        if (block == null) {
            return;
        }
        TileEntity tileEntity = this.world.getBlockTileEntity(x, y, z);
        ItemStack[] result = block.getBreakResult(this.world, EnumDropCause.PICK_BLOCK, x, y, z, meta, tileEntity);
        ItemStack itemStack = selectItem = result != null ? result[0] : null;
        if (selectItem == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i + this.inventory.hotbarOffset);
            if (stack == null || stack.itemID != selectItem.itemID || stack.getMetadata() != selectItem.getMetadata()) continue;
            this.setCurrentItem(i + this.inventory.hotbarOffset);
            return;
        }
        int emptyHotbarSlot = -1;
        int slot = this.inventory.currentItem;
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getStackInSlot(i + this.inventory.hotbarOffset) != null) continue;
            emptyHotbarSlot = i + this.inventory.hotbarOffset;
            slot = i + this.inventory.hotbarOffset;
            break;
        }
        int itemSlot = -1;
        int stackSize = -1;
        for (int i = 9; i < 36; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack == null || stack.itemID != selectItem.itemID || stack.getMetadata() != selectItem.getMetadata() || stackSize != -1 && stack.stackSize >= stackSize) continue;
            itemSlot = i;
            stackSize = stack.stackSize;
        }
        if (itemSlot == -1) {
            if (!this.getGamemode().consumeBlocks()) {
                int emptySlot = -1;
                for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
                    if (this.inventory.getStackInSlot(i) != null) continue;
                    emptySlot = i;
                    break;
                }
                int createItemInsertSlot = emptyHotbarSlot != -1 ? emptyHotbarSlot : this.inventory.currentItem;
                selectItem.stackSize = 1;
                if (emptySlot != -1) {
                    this.swapItems(emptySlot, createItemInsertSlot);
                }
                this.inventory.setInventorySlotContents(createItemInsertSlot, selectItem);
                this.setCurrentItem(createItemInsertSlot);
            }
            return;
        }
        this.swapItems(slot, itemSlot);
        this.setCurrentItem(slot);
    }

    public void setCurrentItem(int i) {
        this.inventory.currentItem = i;
    }

    public void swapItems(int slot1, int slot2) {
        ItemStack stack1 = this.inventory.getStackInSlot(slot1);
        ItemStack stack2 = this.inventory.getStackInSlot(slot2);
        this.inventory.setInventorySlotContents(slot2, stack1);
        this.inventory.setInventorySlotContents(slot1, stack2);
    }

    public static class SortByUsername
    implements Comparator<EntityPlayer> {
        @Override
        public int compare(EntityPlayer o1, EntityPlayer o2) {
            return o1.username.compareTo(o2.username);
        }
    }
}

