/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import net.minecraft.core.HitResult;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.monster.EntityGhast;
import net.minecraft.core.entity.projectile.EntityProjectile;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityFireball
extends EntityProjectile {
    public double accelX;
    public double accelY;
    public double accelZ;

    public EntityFireball(World world) {
        super(world);
        this.setSize(1.0f, 1.0f);
    }

    public EntityFireball(World world, double x, double y, double z, double vX, double vY, double vZ) {
        super(world);
        this.setSize(1.0f, 1.0f);
        this.moveTo(x, y, z, this.yRot, this.xRot);
        this.setPos(x, y, z);
        double velocity = MathHelper.sqrt_double(vX * vX + vY * vY + vZ * vZ);
        this.accelX = vX / velocity * 0.1;
        this.accelY = vY / velocity * 0.1;
        this.accelZ = vZ / velocity * 0.1;
    }

    public EntityFireball(World world, EntityLiving entityliving, double vX, double vY, double vZ) {
        super(world);
        this.setSize(1.0f, 1.0f);
        this.moveTo(entityliving.x, entityliving.y, entityliving.z, entityliving.yRot, entityliving.xRot);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        double velocity = MathHelper.sqrt_double((vX += this.random.nextGaussian() * 0.4) * vX + (vY += this.random.nextGaussian() * 0.4) * vY + (vZ += this.random.nextGaussian() * 0.4) * vZ);
        this.accelX = vX / velocity * 0.1;
        this.accelY = vY / velocity * 0.1;
        this.accelZ = vZ / velocity * 0.1;
    }

    @Override
    protected void init() {
        this.damage = 0;
        this.defaultGravity = 0.0f;
        this.defaultProjectileSpeed = 1.0f;
    }

    @Override
    public void tick() {
        if (this.world.isClientSide) {
            this.accelX = 0.0;
            this.accelY = 0.0;
            this.accelZ = 0.0;
        }
        this.remainingFireTicks = 10;
        this.world.spawnParticle("flame", this.x, this.y, this.z, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05);
        this.world.spawnParticle("flame", this.x + this.xd * 0.5, this.y + this.yd * 0.5, this.z + this.zd * 0.5, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05);
        super.tick();
    }

    @Override
    public void onHit(HitResult result) {
        if (this.tickCount > 5) {
            if (!this.world.isClientSide) {
                if (result.entity != null) {
                    if (result.entity instanceof EntityGhast) {
                        result.entity.hurt(this.owner, 5, DamageType.COMBAT);
                    } else {
                        result.entity.hurt(this.owner, this.damage, DamageType.COMBAT);
                    }
                }
                this.world.newExplosion(this, this.x, this.y, this.z, 1.5f, true, false);
            }
            this.remove();
        }
    }

    @Override
    public void afterTick() {
        super.afterTick();
        this.xd += this.accelX;
        this.yd += this.accelY;
        this.zd += this.accelZ;
        this.world.spawnParticle("largesmoke", this.x, this.y, this.z, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public float getPickRadius() {
        return 1.0f;
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        this.markHurt();
        if (entity != null) {
            Vec3d vec3d = entity.getLookAngle();
            if (entity instanceof EntityLiving) {
                this.owner = (EntityLiving)entity;
            }
            if (vec3d != null) {
                this.xd = vec3d.xCoord;
                this.yd = vec3d.yCoord;
                this.zd = vec3d.zCoord;
                this.accelX = this.xd * 0.1;
                this.accelY = this.yd * 0.1;
                this.accelZ = this.zd * 0.1;
            }
            return true;
        }
        return false;
    }
}

