/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemFlag
extends Item {
    public ItemFlag(String name, int id) {
        super(name, id);
        this.setMaxStackSize(1);
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        if (this.hasFlagBeenDrawnOn(itemstack) || this.doesFlagContainDyes(itemstack)) {
            return this.getKey() + ".modified";
        }
        return super.getLanguageKey(itemstack);
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        TileEntityFlag flag;
        if (world.getBlockId(blockX, blockY, blockZ) == Block.flag.id && !entityplayer.isSneaking() && (flag = (TileEntityFlag)world.getBlockTileEntity(blockX, blockY, blockZ)) != null) {
            CompoundTag flagData = stack.getData().getCompoundOrDefault("FlagData", new CompoundTag());
            if (this.hasFlagBeenDrawnOn(stack) && this.doesFlagContainDyes(stack)) {
                entityplayer.addChatMessage("flag.overwrite");
                return false;
            }
            flag.copyFlagNBT(flagData);
            flagData.putString("Owner", entityplayer.username);
            stack.getData().putCompound("FlagData", flagData);
            entityplayer.addChatMessage("flag.copied");
            return true;
        }
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (!Block.signPostPlanksOak.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.flag, EnumBlockSoundEffectType.PLACE);
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Block.flag.id, 0);
        stack.consumeItem(entityplayer);
        TileEntityFlag tileentityflag = (TileEntityFlag)world.getBlockTileEntity(blockX, blockY, blockZ);
        if (tileentityflag != null) {
            CompoundTag flagData = stack.getData().getCompoundOrDefault("FlagData", null);
            if (flagData != null) {
                tileentityflag.readFlagNBT(flagData);
            }
            if (!world.isClientSide && tileentityflag.owner.isEmpty()) {
                entityplayer.displayGUIEditFlag(tileentityflag);
            }
        }
        return true;
    }

    public boolean hasFlagBeenDrawnOn(ItemStack stack) {
        CompoundTag flagData = stack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        byte[] colors = flagData.getByteArray("Colors");
        if (colors == null) {
            return false;
        }
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean doesFlagContainDyes(ItemStack stack) {
        CompoundTag flagData = stack.getData().getCompound("FlagData");
        if (flagData == null) {
            return false;
        }
        ListTag items = flagData.getList("Items");
        return items != null && items.tagCount() > 0;
    }
}

