/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;

public class ItemToolPickaxe
extends ItemTool {
    public static Map<Block, Integer> miningLevels = new HashMap<Block, Integer>();

    public ItemToolPickaxe(String name, int id, ToolMaterial enumtoolmaterial) {
        super(name, id, 2, enumtoolmaterial, BlockTags.MINEABLE_BY_PICKAXE);
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        Integer miningLevel = miningLevels.get(block);
        if (miningLevel != null) {
            return this.material.getMiningLevel() >= miningLevel;
        }
        return block.hasTag(BlockTags.MINEABLE_BY_PICKAXE);
    }

    static {
        miningLevels.put(Block.obsidian, 3);
        miningLevels.put(Block.blockDiamond, 2);
        miningLevels.put(Block.oreDiamondStone, 2);
        miningLevels.put(Block.oreDiamondBasalt, 2);
        miningLevels.put(Block.oreDiamondGranite, 2);
        miningLevels.put(Block.oreDiamondLimestone, 2);
        miningLevels.put(Block.blockGold, 2);
        miningLevels.put(Block.oreGoldStone, 2);
        miningLevels.put(Block.oreGoldBasalt, 2);
        miningLevels.put(Block.oreGoldGranite, 2);
        miningLevels.put(Block.oreGoldLimestone, 2);
        miningLevels.put(Block.blockIron, 1);
        miningLevels.put(Block.oreIronStone, 1);
        miningLevels.put(Block.oreIronBasalt, 1);
        miningLevels.put(Block.oreIronGranite, 1);
        miningLevels.put(Block.oreIronLimestone, 1);
        miningLevels.put(Block.blockSteel, 2);
        miningLevels.put(Block.oreNethercoalNetherrack, 2);
        miningLevels.put(Block.blockLapis, 1);
        miningLevels.put(Block.oreLapisStone, 1);
        miningLevels.put(Block.oreLapisBasalt, 1);
        miningLevels.put(Block.oreLapisGranite, 1);
        miningLevels.put(Block.oreLapisLimestone, 1);
        miningLevels.put(Block.blockRedstone, 2);
        miningLevels.put(Block.oreRedstoneStone, 2);
        miningLevels.put(Block.oreRedstoneBasalt, 2);
        miningLevels.put(Block.oreRedstoneGranite, 2);
        miningLevels.put(Block.oreRedstoneLimestone, 2);
        miningLevels.put(Block.oreRedstoneGlowingStone, 2);
        miningLevels.put(Block.oreRedstoneGlowingBasalt, 2);
        miningLevels.put(Block.oreRedstoneGlowingGranite, 2);
        miningLevels.put(Block.oreRedstoneGlowingLimestone, 2);
    }
}

