/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet250CustomPayload
extends Packet {
    public String channel;
    public byte[] data;

    public Packet250CustomPayload() {
    }

    public Packet250CustomPayload(String channel, byte[] data) {
        this.channel = channel;
        if (data != null) {
            if (data.length > 32768) {
                throw new IllegalArgumentException("Payload may not be larger than 32k");
            }
            this.data = data;
        }
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.channel = Packet250CustomPayload.readString(in, 20);
        int length = in.readInt();
        if (length > 0 && length < 32768) {
            this.data = new byte[length];
            in.read(this.data);
        }
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        Packet250CustomPayload.writeString(this.channel, out);
        if (this.data != null) {
            out.writeInt(this.data.length);
            out.write(this.data);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleCustomPayload(this);
    }

    @Override
    public int getPacketSize() {
        return this.channel.length() + 4 + this.data.length;
    }
}

