/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.enums.EnumArt;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet25EntityPainting
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int direction;
    public String title;

    public Packet25EntityPainting() {
    }

    public Packet25EntityPainting(EntityPainting entitypainting) {
        this.entityId = entitypainting.id;
        this.xPosition = entitypainting.xPosition;
        this.yPosition = entitypainting.yPosition;
        this.zPosition = entitypainting.zPosition;
        this.direction = entitypainting.direction;
        this.title = entitypainting.art.key;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.title = Packet25EntityPainting.readString(dis, EnumArt.maxArtTitleLength);
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.direction = dis.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        Packet25EntityPainting.writeString(this.title, dos);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeInt(this.direction);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleEntityPainting(this);
    }

    @Override
    public int getPacketSize() {
        return 24;
    }
}

