/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet26BoatControl
extends Packet {
    public int entityId;
    public float targetXD;
    public float targetZD;
    public float targetYRot;

    public Packet26BoatControl() {
    }

    public Packet26BoatControl(Entity entity) {
        this.entityId = entity.id;
        this.targetXD = (float)entity.xd;
        this.targetZD = (float)entity.zd;
        this.targetYRot = entity.yRot;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.targetXD = dis.readFloat();
        this.targetZD = dis.readFloat();
        this.targetYRot = dis.readFloat();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeFloat(this.targetXD);
        dos.writeFloat(this.targetZD);
        dos.writeFloat(this.targetYRot);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleBoatControl(this);
    }

    @Override
    public int getPacketSize() {
        return 12;
    }
}

