/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pathfinder;

public class IdHashMap {
    private transient Entry[] entries = new Entry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;

    private static int getHash(int i) {
        i ^= i >>> 20 ^ i >>> 12;
        return i ^ i >>> 7 ^ i >>> 4;
    }

    private static int getEntryIndex(int i, int j) {
        return i & j - 1;
    }

    public Object get(int id) {
        int j = IdHashMap.getHash(id);
        Entry mchashentry = this.entries[IdHashMap.getEntryIndex(j, this.entries.length)];
        while (mchashentry != null) {
            if (mchashentry.hash == id) {
                return mchashentry.value;
            }
            mchashentry = mchashentry.next;
        }
        return null;
    }

    public boolean containsItem(int i) {
        return this.lookupEntry(i) != null;
    }

    final Entry lookupEntry(int i) {
        int j = IdHashMap.getHash(i);
        Entry mchashentry = this.entries[IdHashMap.getEntryIndex(j, this.entries.length)];
        while (mchashentry != null) {
            if (mchashentry.hash == i) {
                return mchashentry;
            }
            mchashentry = mchashentry.next;
        }
        return null;
    }

    public void add(int key, Object item) {
        int j = IdHashMap.getHash(key);
        int k = IdHashMap.getEntryIndex(j, this.entries.length);
        Entry mchashentry = this.entries[k];
        while (mchashentry != null) {
            if (mchashentry.hash == key) {
                mchashentry.value = item;
            }
            mchashentry = mchashentry.next;
        }
        ++this.versionStamp;
        this.insert(j, key, item, k);
    }

    private void grow(int i) {
        Entry[] amchashentry = this.entries;
        int j = amchashentry.length;
        if (j == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] amchashentry1 = new Entry[i];
        this.copy(amchashentry1);
        this.entries = amchashentry1;
        this.threshold = (int)((float)i * 0.75f);
    }

    private void copy(Entry[] amchashentry) {
        Entry[] amchashentry1 = this.entries;
        int i = amchashentry.length;
        for (int j = 0; j < amchashentry1.length; ++j) {
            Entry mchashentry1;
            Entry mchashentry = amchashentry1[j];
            if (mchashentry == null) continue;
            amchashentry1[j] = null;
            do {
                mchashentry1 = mchashentry.next;
                int k = IdHashMap.getEntryIndex(mchashentry.entryIndex, i);
                mchashentry.next = amchashentry[k];
                amchashentry[k] = mchashentry;
            } while ((mchashentry = mchashentry1) != null);
        }
    }

    public Object remove(int id) {
        Entry mchashentry = this.removeEntry(id);
        return mchashentry != null ? mchashentry.value : null;
    }

    final Entry removeEntry(int id) {
        Entry mchashentry;
        int j = IdHashMap.getHash(id);
        int k = IdHashMap.getEntryIndex(j, this.entries.length);
        Entry mchashentry1 = mchashentry = this.entries[k];
        while (mchashentry1 != null) {
            Entry mchashentry2 = mchashentry1.next;
            if (mchashentry1.hash == id) {
                ++this.versionStamp;
                --this.count;
                if (mchashentry == mchashentry1) {
                    this.entries[k] = mchashentry2;
                } else {
                    mchashentry.next = mchashentry2;
                }
                return mchashentry1;
            }
            mchashentry = mchashentry1;
            mchashentry1 = mchashentry2;
        }
        return mchashentry1;
    }

    public void clear() {
        ++this.versionStamp;
        Entry[] amchashentry = this.entries;
        for (int i = 0; i < amchashentry.length; ++i) {
            amchashentry[i] = null;
        }
        this.count = 0;
    }

    private void insert(int i, int j, Object obj, int k) {
        Entry mchashentry = this.entries[k];
        this.entries[k] = new Entry(i, j, obj, mchashentry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.entries.length);
        }
    }

    class Entry {
        final int hash;
        Object value;
        Entry next;
        final int entryIndex;

        Entry(int entryIndex, int hash, Object value, Entry next) {
            this.value = value;
            this.next = next;
            this.hash = hash;
            this.entryIndex = entryIndex;
        }

        public final int getHash() {
            return this.hash;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean equals(Object that) {
            Object obj2;
            Object obj1;
            Integer integer1;
            if (!(that instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)that;
            Integer integer = this.getHash();
            return (integer == (integer1 = Integer.valueOf(entry.getHash())) || integer != null && integer.equals(integer1)) && ((obj1 = this.getValue()) == (obj2 = entry.getValue()) || obj1 != null && obj1.equals(obj2));
        }

        public final int hashCode() {
            return IdHashMap.getHash(this.hash);
        }

        public final String toString() {
            return this.getHash() + "=" + this.getValue();
        }
    }
}

