/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.season;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonFall;
import net.minecraft.core.world.season.SeasonNull;
import net.minecraft.core.world.season.SeasonOverworldHell;
import net.minecraft.core.world.season.SeasonParadiseGold;
import net.minecraft.core.world.season.SeasonParadiseSilver;
import net.minecraft.core.world.season.SeasonSpring;
import net.minecraft.core.world.season.SeasonSummer;
import net.minecraft.core.world.season.SeasonWinter;
import net.minecraft.core.world.weather.Weather;

public abstract class Seasons {
    private static final Map<String, Season> SEASONS_MAP = new HashMap<String, Season>();
    public static final Season NULL = Seasons.register(new SeasonNull("null"));
    public static final Season OVERWORLD_SPRING = Seasons.register(new SeasonSpring("overworld.spring").allowWeather(Weather.overworldRain, 0.3f).allowWeather(Weather.overworldFog, 0.3f).setDayLength(0.5f).setCropGrowthFactor(1.5f).setGrowFlowers().setSaplingDropFactor(2.0f));
    public static final Season OVERWORLD_SUMMER = Seasons.register(new SeasonSummer("overworld.summer").allowWeather(Weather.overworldRain, 0.1f).allowWeather(Weather.overworldStorm, 0.1f).setDayLength(0.6f));
    public static final Season OVERWORLD_FALL = Seasons.register(new SeasonFall("overworld.fall").allowWeather(Weather.overworldRain, 0.2f).allowWeather(Weather.overworldStorm, 0.05f).allowWeather(Weather.overworldFog, 0.5f).setDayLength(0.5f).setSaplingDropFactor(0.5f));
    public static final Season OVERWORLD_WINTER = Seasons.register(new SeasonWinter("overworld.winter").allowWeather(Weather.overworldSnow, 0.5f).allowWeather(Weather.overworldFog, 0.25f).setLetWeatherCleanUpSnow(false).setDayLength(0.3f).setCropGrowthFactor(0.25f).setKillFlowers().setSaplingDropFactor(0.1f));
    public static final Season OVERWORLD_HELL = Seasons.register(new SeasonOverworldHell("overworld.hell"));
    public static final Season OVERWORLD_WINTER_ENDLESS = Seasons.register(new SeasonWinter("overworld.winter.endless").allowWeather(Weather.overworldWinterSnow, 1.0f).setLetWeatherCleanUpSnow(false).setDayLength(0.3f).setCropGrowthFactor(0.25f).setKillFlowers().setSaplingDropFactor(0.1f));
    public static final Season PARADISE_GOLD = Seasons.register(new SeasonParadiseGold("paradise.gold").setLetWeatherCleanUpSnow(false));
    public static final Season PARADISE_SILVER = Seasons.register(new SeasonParadiseSilver("paradise.silver").setLetWeatherCleanUpSnow(false));

    public static Season getSeason(String key) {
        return SEASONS_MAP.getOrDefault(key, NULL);
    }

    public static Season register(Season season) {
        if (SEASONS_MAP.containsKey(season.getId())) {
            throw new IllegalArgumentException("Season with ID \"" + season.getId() + "\" is already registered!");
        }
        SEASONS_MAP.put(season.getId(), season);
        return season;
    }
}

