/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.animal.IAnimal;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityEgg;
import net.minecraft.core.entity.projectile.EntityFireball;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet17Sleep;
import net.minecraft.core.net.packet.Packet20NamedEntitySpawn;
import net.minecraft.core.net.packet.Packet21PickupSpawn;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.core.net.packet.Packet24MobSpawn;
import net.minecraft.core.net.packet.Packet25EntityPainting;
import net.minecraft.core.net.packet.Packet28EntityVelocity;
import net.minecraft.core.net.packet.Packet29DestroyEntity;
import net.minecraft.core.net.packet.Packet31RelEntityMove;
import net.minecraft.core.net.packet.Packet32EntityLook;
import net.minecraft.core.net.packet.Packet33RelEntityMoveLook;
import net.minecraft.core.net.packet.Packet34EntityTeleport;
import net.minecraft.core.net.packet.Packet35EntityNickname;
import net.minecraft.core.net.packet.Packet40EntityMetadata;
import net.minecraft.core.net.packet.Packet42EntityTagData;
import net.minecraft.core.net.packet.Packet5PlayerInventory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class EntityTrackerEntry {
    public Entity trackedEntity;
    public int trackingDistance;
    public int packetDelay;
    public int encodedPosX;
    public int encodedPosY;
    public int encodedPosZ;
    public int encodedRotationYaw;
    public int encodedRotationPitch;
    public double lastTrackedEntityMotionX;
    public double lastTrackedEntityMotionY;
    public double lastTrackedEntityMotionZ;
    public int updateCounter = 0;
    private double lastTrackedEntityPosX;
    private double lastTrackedEntityPosY;
    private double lastTrackedEntityPosZ;
    private boolean firstUpdateDone = false;
    private boolean shouldSendMotionUpdates;
    private int field_28165_t = 0;
    public boolean playerEntitiesUpdated = false;
    public Set trackedPlayers = new HashSet();

    public EntityTrackerEntry(Entity entity, int trackingDistance, int packetDelay, boolean shouldSendMotionUpdates) {
        this.trackedEntity = entity;
        this.trackingDistance = trackingDistance;
        this.packetDelay = packetDelay;
        this.shouldSendMotionUpdates = shouldSendMotionUpdates;
        this.encodedPosX = MathHelper.floor_double(entity.x * 32.0);
        this.encodedPosY = MathHelper.floor_double(entity.y * 32.0);
        this.encodedPosZ = MathHelper.floor_double(entity.z * 32.0);
        this.encodedRotationYaw = MathHelper.floor_float(entity.yRot * 256.0f / 360.0f);
        this.encodedRotationPitch = MathHelper.floor_float(entity.xRot * 256.0f / 360.0f);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)obj).trackedEntity.id == this.trackedEntity.id;
        }
        return false;
    }

    public int hashCode() {
        return this.trackedEntity.id;
    }

    public void tick(List list) {
        this.playerEntitiesUpdated = false;
        if (!this.firstUpdateDone || this.trackedEntity.distanceToSqr(this.lastTrackedEntityPosX, this.lastTrackedEntityPosY, this.lastTrackedEntityPosZ) > 16.0) {
            this.lastTrackedEntityPosX = this.trackedEntity.x;
            this.lastTrackedEntityPosY = this.trackedEntity.y;
            this.lastTrackedEntityPosZ = this.trackedEntity.z;
            this.firstUpdateDone = true;
            this.playerEntitiesUpdated = true;
            this.updatePlayerEntities(list);
        }
        ++this.field_28165_t;
        if (++this.updateCounter % this.packetDelay == 0) {
            SynchedEntityData datawatcher;
            double d3;
            double d2;
            double d1;
            double d;
            double d4;
            boolean hasLooked;
            int entityX = MathHelper.floor_double(this.trackedEntity.x * 32.0);
            int entityY = MathHelper.floor_double(this.trackedEntity.y * 32.0);
            int entityZ = MathHelper.floor_double(this.trackedEntity.z * 32.0);
            int entityYaw = MathHelper.floor_float(this.trackedEntity.yRot * 256.0f / 360.0f);
            int entityPitch = MathHelper.floor_float(this.trackedEntity.xRot * 256.0f / 360.0f);
            int dx = entityX - this.encodedPosX;
            int dy = entityY - this.encodedPosY;
            int dz = entityZ - this.encodedPosZ;
            Packet obj = null;
            boolean hasMoved = Math.abs(entityX) >= 8 || Math.abs(entityY) >= 8 || Math.abs(entityZ) >= 8;
            boolean bl = hasLooked = Math.abs(entityYaw - this.encodedRotationYaw) >= 8 || Math.abs(entityPitch - this.encodedRotationPitch) >= 8;
            if (dx < -128 || dx >= 128 || dy < -128 || dy >= 128 || dz < -128 || dz >= 128 || this.field_28165_t > 400) {
                this.field_28165_t = 0;
                this.trackedEntity.x = (double)entityX / 32.0;
                this.trackedEntity.y = (double)entityY / 32.0;
                this.trackedEntity.z = (double)entityZ / 32.0;
                obj = new Packet34EntityTeleport(this.trackedEntity.id, entityX, entityY, entityZ, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved && hasLooked) {
                obj = new Packet33RelEntityMoveLook(this.trackedEntity.id, (byte)dx, (byte)dy, (byte)dz, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved) {
                obj = new Packet31RelEntityMove(this.trackedEntity.id, (byte)dx, (byte)dy, (byte)dz);
            } else if (hasLooked) {
                obj = new Packet32EntityLook(this.trackedEntity.id, (byte)entityYaw, (byte)entityPitch);
            }
            if (this.shouldSendMotionUpdates && ((d4 = (d = this.trackedEntity.xd - this.lastTrackedEntityMotionX) * d + (d1 = this.trackedEntity.yd - this.lastTrackedEntityMotionY) * d1 + (d2 = this.trackedEntity.zd - this.lastTrackedEntityMotionZ) * d2) > (d3 = 0.02) * d3 || d4 > 0.0 && this.trackedEntity.xd == 0.0 && this.trackedEntity.yd == 0.0 && this.trackedEntity.zd == 0.0)) {
                this.lastTrackedEntityMotionX = this.trackedEntity.xd;
                this.lastTrackedEntityMotionY = this.trackedEntity.yd;
                this.lastTrackedEntityMotionZ = this.trackedEntity.zd;
                this.sendPacketToTrackedPlayers(new Packet28EntityVelocity(this.trackedEntity.id, this.lastTrackedEntityMotionX, this.lastTrackedEntityMotionY, this.lastTrackedEntityMotionZ));
            }
            if (obj != null) {
                this.sendPacketToTrackedPlayers(obj);
            }
            if ((datawatcher = this.trackedEntity.getEntityData()).isDirty()) {
                this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet40EntityMetadata(this.trackedEntity.id, datawatcher));
            }
            if (hasMoved) {
                this.encodedPosX = entityX;
                this.encodedPosY = entityY;
                this.encodedPosZ = entityZ;
            }
            if (hasLooked) {
                this.encodedRotationYaw = entityYaw;
                this.encodedRotationPitch = entityPitch;
            }
        }
        if (this.trackedEntity.hurtMarked) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet28EntityVelocity(this.trackedEntity));
            this.trackedEntity.hurtMarked = false;
        }
        if (this.trackedEntity.hadNicknameSet) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet35EntityNickname(this.trackedEntity.id, ((EntityLiving)this.trackedEntity).nickname, ((EntityLiving)this.trackedEntity).chatColor));
            this.trackedEntity.hadNicknameSet = false;
        }
    }

    public void sendPacketToTrackedPlayers(Packet packet) {
        for (EntityPlayerMP entityplayermp : this.trackedPlayers) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Packet packet) {
        this.sendPacketToTrackedPlayers(packet);
        if (this.trackedEntity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.trackedEntity).playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendDestroyEntityPacketToTrackedPlayers() {
        this.sendPacketToTrackedPlayers(new Packet29DestroyEntity(this.trackedEntity.id));
    }

    public void removeFromTrackedPlayers(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
        }
    }

    public void updatePlayerEntity(EntityPlayerMP entityplayermp) {
        if (entityplayermp == this.trackedEntity) {
            return;
        }
        double d = entityplayermp.x - (double)(this.encodedPosX / 32);
        double d1 = entityplayermp.z - (double)(this.encodedPosZ / 32);
        if (d >= (double)(-this.trackingDistance) && d <= (double)this.trackingDistance && d1 >= (double)(-this.trackingDistance) && d1 <= (double)this.trackingDistance) {
            if (!this.trackedPlayers.contains(entityplayermp)) {
                EntityPlayer entityplayer;
                ItemStack[] aitemstack;
                this.trackedPlayers.add(entityplayermp);
                entityplayermp.playerNetServerHandler.sendPacket(this.getSpawnPacket());
                if (this.trackedEntity.sendAdditionalData) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet42EntityTagData(this.trackedEntity));
                }
                if (this.shouldSendMotionUpdates) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet28EntityVelocity(this.trackedEntity.id, this.trackedEntity.xd, this.trackedEntity.yd, this.trackedEntity.zd));
                }
                if ((aitemstack = this.trackedEntity.getInventory()) != null) {
                    for (int i = 0; i < aitemstack.length; ++i) {
                        entityplayermp.playerNetServerHandler.sendPacket(new Packet5PlayerInventory(this.trackedEntity.id, i, aitemstack[i]));
                    }
                }
                if (this.trackedEntity instanceof EntityPlayer && (entityplayer = (EntityPlayer)this.trackedEntity).isPlayerSleeping()) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet17Sleep(this.trackedEntity, 0, MathHelper.floor_double(this.trackedEntity.x), MathHelper.floor_double(this.trackedEntity.y), MathHelper.floor_double(this.trackedEntity.z)));
                }
            }
        } else if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.id));
        }
    }

    public void updatePlayerEntities(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.updatePlayerEntity((EntityPlayerMP)list.get(i));
        }
    }

    private Packet getSpawnPacket() {
        EntityLiving entityliving;
        if (this.trackedEntity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)this.trackedEntity;
            Packet21PickupSpawn packet21pickupspawn = new Packet21PickupSpawn(entityitem);
            entityitem.x = (double)packet21pickupspawn.xPosition / 32.0;
            entityitem.y = (double)packet21pickupspawn.yPosition / 32.0;
            entityitem.z = (double)packet21pickupspawn.zPosition / 32.0;
            return packet21pickupspawn;
        }
        if (this.trackedEntity instanceof EntityPlayerMP) {
            return new Packet20NamedEntitySpawn((EntityPlayer)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityMinecart) {
            EntityMinecart entityminecart = (EntityMinecart)this.trackedEntity;
            if (entityminecart.minecartType == 0) {
                return new Packet23VehicleSpawn(this.trackedEntity, 10);
            }
            if (entityminecart.minecartType == 1) {
                return new Packet23VehicleSpawn(this.trackedEntity, 11);
            }
            if (entityminecart.minecartType == 2) {
                return new Packet23VehicleSpawn(this.trackedEntity, 12);
            }
        }
        if (this.trackedEntity instanceof EntityBoat) {
            return new Packet23VehicleSpawn(this.trackedEntity, 1);
        }
        if (this.trackedEntity instanceof IAnimal) {
            return new Packet24MobSpawn((EntityLiving)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityBobber) {
            return new Packet23VehicleSpawn(this.trackedEntity, 90);
        }
        if (this.trackedEntity instanceof EntityArrow) {
            entityliving = ((EntityArrow)this.trackedEntity).owner;
            return new Packet23VehicleSpawn(this.trackedEntity, 60, entityliving == null ? this.trackedEntity.id : entityliving.id);
        }
        if (this.trackedEntity instanceof EntityCannonball) {
            entityliving = ((EntityCannonball)this.trackedEntity).owner;
            return new Packet23VehicleSpawn(this.trackedEntity, 72, entityliving == null ? this.trackedEntity.id : entityliving.id);
        }
        if (this.trackedEntity instanceof EntitySnowball) {
            return new Packet23VehicleSpawn(this.trackedEntity, 61);
        }
        if (this.trackedEntity instanceof EntityFireball) {
            EntityFireball entityfireball = (EntityFireball)this.trackedEntity;
            Packet23VehicleSpawn packet23vehiclespawn = new Packet23VehicleSpawn(this.trackedEntity, 63, ((EntityFireball)this.trackedEntity).owner == null ? -1 : ((EntityFireball)this.trackedEntity).owner.id);
            packet23vehiclespawn.field_28047_e = (int)(entityfireball.accelX * 8000.0);
            packet23vehiclespawn.field_28046_f = (int)(entityfireball.accelY * 8000.0);
            packet23vehiclespawn.field_28045_g = (int)(entityfireball.accelZ * 8000.0);
            return packet23vehiclespawn;
        }
        if (this.trackedEntity instanceof EntityEgg) {
            return new Packet23VehicleSpawn(this.trackedEntity, 62);
        }
        if (this.trackedEntity instanceof EntityPebble) {
            return new Packet23VehicleSpawn(this.trackedEntity, 64);
        }
        if (this.trackedEntity instanceof EntityTNT) {
            return new Packet23VehicleSpawn(this.trackedEntity, 50);
        }
        if (this.trackedEntity instanceof EntityFallingSand) {
            EntityFallingSand entityfallingsand = (EntityFallingSand)this.trackedEntity;
            if (entityfallingsand.blockID == Block.sand.id) {
                return new Packet23VehicleSpawn(this.trackedEntity, 70);
            }
            if (entityfallingsand.blockID == Block.gravel.id) {
                return new Packet23VehicleSpawn(this.trackedEntity, 71);
            }
            if (entityfallingsand.blockID == Block.mud.id) {
                return new Packet23VehicleSpawn(this.trackedEntity, 73);
            }
        }
        if (this.trackedEntity instanceof EntityPainting) {
            return new Packet25EntityPainting((EntityPainting)this.trackedEntity);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.trackedEntity.getClass() + "!");
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.id));
        }
    }
}

