/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.packet.Packet61PlaySoundEffect;
import net.minecraft.core.net.packet.Packet62PlaySoundDirect;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.world.LevelListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.WorldServer;

public class WorldManager
implements LevelListener {
    private static Set<String> unknownSoundTypes = new HashSet<String>();
    private MinecraftServer mcServer;
    private WorldServer worldServer;

    public WorldManager(MinecraftServer minecraftserver, WorldServer worldserver) {
        this.mcServer = minecraftserver;
        this.worldServer = worldserver;
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, double maxDistance) {
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ) {
    }

    @Override
    public void entityAdded(Entity entity) {
        if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            if (entityItem.item == null || entityItem.item.getItem() == null) {
                return;
            }
        }
        this.mcServer.getEntityTracker(this.worldServer.dimension.id).trackEntity(entity);
    }

    @Override
    public void entityRemoved(Entity entity) {
        this.mcServer.getEntityTracker(this.worldServer.dimension.id).untrackEntity(entity);
    }

    @Override
    public void playSound(Entity player, String soundPath, SoundCategory soundType, double x, double y, double z, float volume, float pitch) {
        if (soundPath == null) {
            return;
        }
        int soundId = SoundTypes.getSoundId(soundPath);
        if (soundId == -1) {
            if (!unknownSoundTypes.contains(soundPath)) {
                System.out.println("Unable to play unknown sound '" + soundPath + "'!");
                unknownSoundTypes.add(soundPath);
            }
            return;
        }
        Packet62PlaySoundDirect packet = new Packet62PlaySoundDirect(soundId, soundType, x, y, z, volume, pitch);
        float range = 16.0f;
        if (volume > 1.0f) {
            range *= volume;
        }
        EntityPlayer entityPlayer = null;
        if (player instanceof EntityPlayer) {
            entityPlayer = (EntityPlayer)player;
        }
        this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(entityPlayer, x, y, z, range, this.worldServer.dimension.id, packet);
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
    }

    @Override
    public void allChanged() {
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.mcServer.playerList.markBlockNeedsUpdate(x, y, z, this.worldServer.dimension.id);
    }

    @Override
    public void playStreamingMusic(String soundPath, int x, int y, int z) {
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity tileEntity) {
        this.mcServer.playerList.sendTileEntityToPlayer(x, y, z, tileEntity);
    }

    @Override
    public void levelEvent(EntityPlayer player, int id, int x, int y, int z, int data) {
        this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(player, x, y, z, 64.0, this.worldServer.dimension.id, new Packet61PlaySoundEffect(id, x, y, z, data));
    }
}

