/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.net.packet.Packet101CloseWindow;
import net.minecraft.core.net.packet.Packet107UpdateCreativeInventory;
import net.minecraft.core.net.packet.Packet108SetHotbarOffset;
import net.minecraft.core.net.packet.Packet10Flying;
import net.minecraft.core.net.packet.Packet11PlayerPosition;
import net.minecraft.core.net.packet.Packet12PlayerLook;
import net.minecraft.core.net.packet.Packet133OpenGuidebook;
import net.minecraft.core.net.packet.Packet13PlayerLookMove;
import net.minecraft.core.net.packet.Packet14BlockDig;
import net.minecraft.core.net.packet.Packet18Animation;
import net.minecraft.core.net.packet.Packet19EntityAction;
import net.minecraft.core.net.packet.Packet250CustomPayload;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet9Respawn;
import net.minecraft.core.player.Session;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class EntityClientPlayerMP
extends EntityPlayerSP {
    public NetClientHandler sendQueue;
    private int field_9380_bx = 0;
    private boolean field_21093_bH = false;
    private double oldPosX;
    private double field_9378_bz;
    private double oldPosY;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private boolean field_9382_bF = false;
    private boolean wasSneaking = false;
    private int field_12242_bI = 0;

    public EntityClientPlayerMP(Minecraft minecraft, World world, Session session, NetClientHandler netclienthandler) {
        super(minecraft, world, session, 0);
        this.sendQueue = netclienthandler;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return false;
    }

    @Override
    public void heal(int i) {
    }

    @Override
    public void tick() {
        if (!this.world.isBlockLoaded(MathHelper.floor_double(this.x), 64, MathHelper.floor_double(this.z))) {
            return;
        }
        super.tick();
        this.func_4056_N();
    }

    public void func_4056_N() {
        boolean flag2;
        boolean flag;
        if (this.field_9380_bx++ == 20) {
            this.sendInventoryChanged();
            this.field_9380_bx = 0;
        }
        if ((flag = this.isSneaking()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 1));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 2));
            }
            this.wasSneaking = flag;
        }
        double d = this.x - this.oldPosX;
        double d1 = this.bb.minY - this.field_9378_bz;
        double d2 = this.y - this.oldPosY;
        double d3 = this.z - this.oldPosZ;
        double d4 = this.yRot - this.oldRotationYaw;
        double d5 = this.xRot - this.oldRotationPitch;
        boolean flag1 = d1 != 0.0 || d2 != 0.0 || d != 0.0 || d3 != 0.0;
        boolean bl = flag2 = d4 != 0.0 || d5 != 0.0;
        if (this.vehicle != null) {
            if (flag2) {
                this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.xd, -999.0, -999.0, this.zd, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.xd, -999.0, -999.0, this.zd, this.yRot, this.xRot, this.onGround));
            }
            flag1 = false;
        } else if (flag1 && flag2) {
            this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.x, this.bb.minY, this.y, this.z, this.yRot, this.xRot, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag1) {
            this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.x, this.bb.minY, this.y, this.z, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new Packet12PlayerLook(this.yRot, this.xRot, this.onGround));
            this.field_12242_bI = 0;
        } else {
            this.sendQueue.addToSendQueue(new Packet10Flying(this.onGround));
            this.field_12242_bI = this.field_9382_bF != this.onGround || this.field_12242_bI > 200 ? 0 : ++this.field_12242_bI;
        }
        this.field_9382_bF = this.onGround;
        if (flag1) {
            this.oldPosX = this.x;
            this.field_9378_bz = this.bb.minY;
            this.oldPosY = this.y;
            this.oldPosZ = this.z;
        }
        if (flag2) {
            this.oldRotationYaw = this.yRot;
            this.oldRotationPitch = this.xRot;
        }
    }

    @Override
    public void dropCurrentItem(boolean dropFullStack) {
        this.sendQueue.addToSendQueue(new Packet14BlockDig(dropFullStack ? 5 : 4, 0, 0, 0, Side.NONE));
    }

    private void sendInventoryChanged() {
    }

    @Override
    protected void joinEntityItemWithWorld(EntityItem entityitem) {
    }

    @Override
    public void sendChatMessage(String s) {
        this.sendQueue.addToSendQueue(new Packet3Chat(s, AES.clientKeyChain));
        this.addToSendHistory(s);
    }

    @Override
    public void updateCreativeInventory(int page, String searchText) {
        this.sendQueue.addToSendQueue(new Packet107UpdateCreativeInventory(this.craftingInventory.windowId, page, searchText));
    }

    @Override
    public void setHotbarOffset(int offset) {
        super.setHotbarOffset(offset);
        this.sendQueue.addToSendQueue(new Packet108SetHotbarOffset(offset));
    }

    @Override
    public void displayGUIGuidebook() {
        this.mc.displayGuiScreen(new GuiGuidebook());
        this.sendQueue.addToSendQueue(new Packet133OpenGuidebook(this.mc.currentScreen instanceof GuiGuidebook));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new Packet18Animation(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendInventoryChanged();
        this.sendQueue.addToSendQueue(new Packet9Respawn((byte)this.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(this.world.worldType)));
    }

    @Override
    protected void damageEntity(int i, DamageType damageType) {
        this.setHealthRaw(this.getHealth() - i);
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new Packet101CloseWindow(this.craftingInventory.windowId));
        this.inventory.setHeldItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int i) {
        if (this.field_21093_bH) {
            super.setHealth(i);
        } else {
            this.setHealthRaw(i);
            this.field_21093_bH = true;
        }
    }

    @Override
    public void addStat(Stat statbase, int i) {
        if (statbase == null) {
            return;
        }
        if (statbase.clientside) {
            super.addStat(statbase, i);
        }
    }

    @Override
    public int getStat(Stat statbase) {
        if (statbase.clientside) {
            return super.getStat(statbase);
        }
        return 0;
    }

    public void func_27027_b(Stat statbase, int i) {
        if (statbase == null) {
            return;
        }
        if (!statbase.clientside) {
            super.addStat(statbase, i);
        }
    }

    @Override
    public void syncPlacementMode() {
        super.syncPlacementMode();
        byte[] data = new byte[]{(byte)(this.rotationLock != null ? this.rotationLock.getId() : -1), (byte)(this.rotationLockHorizontal != null ? this.rotationLockHorizontal.getId() : -1), (byte)(this.rotationLockVertical != null ? this.rotationLockVertical.getId() : -1), (byte)(this.placementModeOverride != null ? this.placementModeOverride.index() : -1)};
        this.sendQueue.addToSendQueue(new Packet250CustomPayload("BTA|RotationLock", data));
    }

    @Override
    public void pickBlock(int x, int y, int z) {
        this.sendQueue.addToSendQueue(new Packet14BlockDig(6, x, y, z, Side.NONE));
    }
}

