/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityPickupFX;
import net.minecraft.client.gui.GuiChest;
import net.minecraft.client.gui.GuiCrafting;
import net.minecraft.client.gui.GuiDispenser;
import net.minecraft.client.gui.GuiEditFlag;
import net.minecraft.client.gui.GuiEditLabel;
import net.minecraft.client.gui.GuiEditSign;
import net.minecraft.client.gui.GuiFurnace;
import net.minecraft.client.gui.GuiPaintingPicker;
import net.minecraft.client.gui.GuiPickMonster;
import net.minecraft.client.gui.GuiTrommel;
import net.minecraft.client.gui.GuiWandPickerMonster;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockPortal;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.ClientPlayerCommandSender;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.Commands;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.GetSkinUrlThread;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class EntityPlayerSP
extends EntityPlayer {
    public PlayerInput input;
    protected Minecraft mc;
    protected List<Command> allowedCommands;
    public final ClientPlayerCommandSender sender;
    protected int sprintTimer;

    public EntityPlayerSP(Minecraft minecraft, World world, Session session, int i) {
        super(world);
        this.mc = minecraft;
        this.sender = new ClientPlayerCommandSender(minecraft, this);
        this.dimension = i;
        this.username = session.username;
        new GetSkinUrlThread(this);
        System.out.println("logged in with session name: " + this.username);
    }

    public float getFovModifier() {
        float f = 1.0f;
        return f *= (this.speed * 1.0f / this.baseSpeed + 1.0f) / 2.0f;
    }

    @Override
    public AABB getBb() {
        if (this.noPhysics) {
            return null;
        }
        return super.getBb();
    }

    @Override
    public void move(double xd, double yd, double zd) {
        super.move(xd, yd, zd);
    }

    @Override
    public void updatePlayerActionState() {
        super.updatePlayerActionState();
        this.moveStrafing = this.input.moveStrafe;
        this.moveForward = this.input.moveForward;
        this.isJumping = this.input.jump;
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
        ContainerPlayer newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    @Override
    public void onLivingUpdate() {
        boolean canSprint;
        float f;
        if (this.sprintTimer > 0) {
            --this.sprintTimer;
        }
        if (!this.mc.statsCounter.isAchievementUnlocked(AchievementList.OPEN_INVENTORY) && !this.mc.guiAchievement.isDisplayingAchievement(AchievementList.OPEN_INVENTORY)) {
            this.mc.guiAchievement.queueAchievementInformation(AchievementList.OPEN_INVENTORY);
        }
        if (this.mc.statsCounter.isAchievementUnlocked(AchievementList.OPEN_INVENTORY) && !this.mc.statsCounter.isAchievementUnlocked(AchievementList.OPEN_GUIDEBOOK) && !this.mc.guiAchievement.isDisplayingAchievement(AchievementList.OPEN_INVENTORY) && !this.mc.guiAchievement.isDisplayingAchievement(AchievementList.OPEN_GUIDEBOOK)) {
            this.mc.guiAchievement.queueAchievementInformation(AchievementList.OPEN_GUIDEBOOK);
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal) {
            if (!this.world.isClientSide && this.vehicle != null) {
                this.startRiding(null);
            }
            if (this.mc.currentScreen != null) {
                this.mc.displayGuiScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSound("portal.trigger", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel()) {
                this.timeInPortal = 1.0f;
                if (!this.world.isClientSide) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSound("portal.travel", SoundCategory.WORLD_SOUNDS, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
                    int targetDim = ((BlockPortal)Block.blocksList[this.portalID]).targetDimension;
                    if (this.dimension == targetDim) {
                        this.mc.usePortal(0);
                    } else {
                        this.mc.usePortal(targetDim);
                    }
                }
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        boolean forwardInput = this.input.moveForward >= (f = 0.8f);
        this.input.tick(this);
        if (this.input.sneak && this.ySlideOffset < 0.45f) {
            this.ySlideOffset = 0.45f;
        }
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        this.checkInTile(this.x - (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z - (double)this.bbWidth * 0.35);
        this.checkInTile(this.x + (double)this.bbWidth * 0.35, this.bb.minY + 0.5, this.z + (double)this.bbWidth * 0.35);
        boolean bl = canSprint = this.world.getGameRuleValue(GameRules.ALLOW_SPRINTING) != false && !this.noPhysics;
        if (this.onGround && !forwardInput && this.input.moveForward >= f && !this.isSprinting() && canSprint) {
            if (this.sprintTimer == 0) {
                this.sprintTimer = 7;
            } else {
                this.setSprinting(true);
                this.sprintTimer = 0;
            }
        }
        if (this.onGround && canSprint && this.mc.gameSettings.keySprint.isPressed()) {
            this.setSprinting(true);
        }
        if (this.isSprinting() && (this.input.moveForward < f || this.horizontalCollision || !canSprint)) {
            this.setSprinting(false);
        }
        super.onLivingUpdate();
        if (this.mc != null) {
            this.mc.ppm.update();
        }
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        super.wakeUpPlayer(flag, flag1);
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Score", this.score);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.score = tag.getInteger("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void displayGUIEditSign(TileEntitySign tileentitysign) {
        this.mc.displayGuiScreen(new GuiEditSign(tileentitysign));
    }

    @Override
    public void displayGUIEditFlag(TileEntityFlag tileEntityFlag) {
        this.mc.displayGuiScreen(new GuiEditFlag(this, tileEntityFlag));
    }

    @Override
    public void displayGUIChest(IInventory iinventory) {
        this.mc.displayGuiScreen(new GuiChest(this.inventory, iinventory));
    }

    @Override
    public void displayGUIWorkbench(int i, int j, int k) {
        this.mc.displayGuiScreen(new GuiCrafting(this.inventory, this.world, i, j, k));
    }

    @Override
    public void displayGUIEditLabel(ItemStack itemstack, int slot) {
        this.mc.displayGuiScreen(new GuiEditLabel(itemstack, slot));
    }

    @Override
    public void displayGUIPaintingPicker() {
        this.mc.displayGuiScreen(new GuiPaintingPicker(this));
    }

    @Override
    public void displayGUIMobSpawnerPicker(int x, int y, int z) {
        String currentMobId = ((TileEntityMobSpawner)this.world.getBlockTileEntity(x, y, z)).getMobId();
        this.mc.displayGuiScreen(new GuiPickMonster(currentMobId, x, y, z));
    }

    @Override
    public void displayGUIWandMonsterPicker(ItemStack stack) {
        String currentMobId = stack.getData().getStringOrDefault("monster", "Pig");
        this.mc.displayGuiScreen(new GuiWandPickerMonster(currentMobId, stack));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.mc.displayGuiScreen(new GuiFurnace(this.inventory, tileentityfurnace));
    }

    @Override
    public void displayGUITrommel(TileEntityTrommel tileEntityTrommel) {
        this.mc.displayGuiScreen(new GuiTrommel(this.inventory, tileEntityTrommel));
    }

    @Override
    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
        this.mc.displayGuiScreen(new GuiDispenser(this.inventory, tileentitydispenser));
    }

    public void displayGUIGuidebook() {
        this.mc.displayGuiScreen(new GuiGuidebook());
    }

    @Override
    public void onItemPickup(Entity entity, int i) {
        this.addStat(StatList.pickUpItemStats[i], 1);
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, entity, this, -0.5f));
    }

    public int getPlayerProtectionAmount() {
        return this.inventory.getTotalArmourPoints();
    }

    public void sendChatMessage(String s) {
        this.addToSendHistory(s);
        if (s.startsWith("/")) {
            try {
                String[] args = s.substring(1).split(" ");
                String[] args1 = new String[args.length - 1];
                System.arraycopy(args, 1, args1, 0, args.length - 1);
                ClientCommandHandler handler = this.mc.commandHandler;
                for (Command command : Commands.commands) {
                    if (!command.isName(args[0])) continue;
                    if (!this.sender.isAdmin() && command.opRequired(args1)) {
                        this.sender.sendMessage("You don't have permission to use this command!");
                        return;
                    }
                    try {
                        boolean success = command.execute(handler, this.sender, args1);
                        if (!success) {
                            command.sendCommandSyntax(handler, this.sender);
                        }
                    }
                    catch (CommandError e) {
                        this.sender.sendMessage(TextFormatting.RED + e.getMessage());
                    }
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mc.ingameGUI.addChatMessage(TextFormatting.RED + "Error!");
            }
        } else {
            this.mc.ingameGUI.addChatMessage("<" + this.getDisplayName() + TextFormatting.RESET + "> " + TextFormatting.WHITE + s);
        }
    }

    public void addToSendHistory(String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.messageHistory.size(); ++i) {
            if (!((String)this.messageHistory.get(i)).equals(msg)) continue;
            this.messageHistory.remove(i--);
        }
        this.messageHistory.add(msg);
        if (this.messageHistory.size() > 100) {
            this.messageHistory.remove(0);
        }
    }

    @Override
    public boolean isSneaking() {
        return this.input.sneak && !this.sleeping;
    }

    public void setHealth(int i) {
        int j = this.getHealth() - i;
        if (j <= 0) {
            this.setHealthRaw(i);
            if (j < 0) {
                this.heartsFlashTime = this.heartsHalvesLife / 2;
            }
        } else {
            this.lastDamage = j;
            this.prevHealth = this.getHealth();
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(j, null);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public void addStat(Stat statbase, int i) {
        if (statbase == null) {
            return;
        }
        if (statbase.isAchievement()) {
            Achievement achievement = (Achievement)statbase;
            if (achievement.parent == null || this.mc.statsCounter.isAchievementUnlocked(achievement.parent)) {
                if (!this.mc.statsCounter.isAchievementUnlocked(achievement)) {
                    this.mc.guiAchievement.queueTakenAchievement(achievement);
                }
                this.mc.statsCounter.addValueToStat(statbase, i);
            }
        } else {
            this.mc.statsCounter.addValueToStat(statbase, i);
        }
    }

    @Override
    public int getStat(Stat statbase) {
        return this.mc.statsCounter.readStat(statbase);
    }

    private boolean isBlockTranslucent(int i, int j, int k) {
        return this.world.isBlockNormalCube(i, j, k);
    }

    @Override
    protected boolean checkInTile(double d, double d1, double d2) {
        if (this.noPhysics) {
            return false;
        }
        int i = MathHelper.floor_double(d);
        int j = MathHelper.floor_double(d1);
        int k = MathHelper.floor_double(d2);
        double d3 = d - (double)i;
        double d4 = d2 - (double)k;
        if (this.isBlockTranslucent(i, j, k) || this.isBlockTranslucent(i, j + 1, k) && !this.isDwarf) {
            boolean flag = !this.isBlockTranslucent(i - 1, j, k) && !this.isBlockTranslucent(i - 1, j + 1, k);
            boolean flag1 = !this.isBlockTranslucent(i + 1, j, k) && !this.isBlockTranslucent(i + 1, j + 1, k);
            boolean flag2 = !this.isBlockTranslucent(i, j, k - 1) && !this.isBlockTranslucent(i, j + 1, k - 1);
            boolean flag3 = !this.isBlockTranslucent(i, j, k + 1) && !this.isBlockTranslucent(i, j + 1, k + 1);
            int byte0 = -1;
            double d5 = 9999.0;
            if (flag && d3 < d5) {
                d5 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d5) {
                d5 = d4;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d4 < d5) {
                double d6 = 1.0 - d4;
                byte0 = 5;
            }
            float f = 0.1f;
            if (byte0 == 0) {
                this.xd = -f;
            }
            if (byte0 == 1) {
                this.xd = f;
            }
            if (byte0 == 4) {
                this.zd = -f;
            }
            if (byte0 == 5) {
                this.zd = f;
            }
        }
        return false;
    }

    public void syncPlacementMode() {
        this.placementModeOverride = (PlacementMode)this.mc.gameSettings.placementMode.value;
    }

    @Override
    public void sendMessage(String message) {
        this.mc.ingameGUI.addChatMessage(message);
    }

    @Override
    public void sendStatusMessage(String message) {
        this.mc.ingameGUI.guiHeldItemTooltip.setString(message);
    }
}

